<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// ===== DEFAULT =====
$routes->get('/', 'Home::index');

// ===== FRONTEND =====
$routes->get('biodata', 'Biodata::index');
$routes->get('pendidikan', 'Pendidikan::index');
$routes->get('aktivitas', 'Aktivitas::index');

// ===== AUTH =====
$routes->get('login', 'Auth::login');
$routes->post('login', 'Auth::doLogin');
$routes->get('logout', 'Auth::logout');

// ===== ADMIN PANEL =====
$routes->group('admin', function ($routes) {

    // REDIRECT ROOT TO PENDIDIKAN
    $routes->get('/', function() {
        return redirect()->to('/admin/pendidikan');
    });

    // ===== PENDIDIKAN =====
    $routes->get('pendidikan', 'Admin\Pendidikan::index');
    $routes->get('pendidikan/create', 'Admin\Pendidikan::create');
    $routes->post('pendidikan/store', 'Admin\Pendidikan::store');
    $routes->get('pendidikan/edit/(:num)', 'Admin\Pendidikan::edit/$1');
    $routes->post('pendidikan/update/(:num)', 'Admin\Pendidikan::update/$1');
    $routes->get('pendidikan/delete/(:num)', 'Admin\Pendidikan::delete/$1');

    // ===== AKTIVITAS =====
    $routes->get('aktivitas', 'Admin\Aktivitas::index');
    $routes->get('aktivitas/create', 'Admin\Aktivitas::create');
    $routes->post('aktivitas/store', 'Admin\Aktivitas::store');
    $routes->get('aktivitas/edit/(:num)', 'Admin\Aktivitas::edit/$1');
    $routes->post('aktivitas/update/(:num)', 'Admin\Aktivitas::update/$1');
    $routes->get('aktivitas/delete/(:num)', 'Admin\Aktivitas::delete/$1');

});
