<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AktivitasModel;

class Aktivitas extends BaseController
{
    protected $aktivitas;

    public function __construct()
    {
        $this->aktivitas = new AktivitasModel();
    }

    // ===============================
    // INDEX (LIST AKTIVITAS)
    // ===============================
    public function index()
    {
        $data['aktivitas'] = $this->aktivitas
            ->orderBy('tanggal', 'DESC')
            ->orderBy('waktu', 'DESC')
            ->findAll();

        return view('admin/aktivitas/index', $data);
    }

    // ===============================
    // FORM TAMBAH
    // ===============================
    public function create()
    {
        return view('admin/aktivitas/create');
    }

    // ===============================
    // SIMPAN DATA
    // ===============================
    public function store()
    {
        $file = $this->request->getFile('file');

        $namaFile = null;
        if ($file && $file->isValid()) {
            $namaFile = $file->getRandomName();
            $file->move('img/activity', $namaFile);
        }

        $this->aktivitas->insert([
            'judul'     => $this->request->getPost('judul'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'tanggal'   => $this->request->getPost('tanggal'),
            'waktu'     => $this->request->getPost('waktu'),
            'tipe'      => $this->request->getPost('tipe'),
            'file'      => $namaFile,
        ]);

        return redirect()->to('/admin/aktivitas')->with('success', 'Aktivitas berhasil ditambahkan');
    }

    // ===============================
    // FORM EDIT
    // ===============================
    public function edit($id)
    {
        $data['act'] = $this->aktivitas->find($id);

        return view('admin/aktivitas/edit', $data);
    }

    // ===============================
    // UPDATE DATA
    // ===============================
    public function update($id)
    {
        $act  = $this->aktivitas->find($id);
        $file = $this->request->getFile('file');

        $namaFile = $act['file'];

        if ($file && $file->isValid()) {
            if ($namaFile && file_exists('img/activity/' . $namaFile)) {
                unlink('img/activity/' . $namaFile);
            }

            $namaFile = $file->getRandomName();
            $file->move('img/activity', $namaFile);
        }

        $this->aktivitas->update($id, [
            'judul'     => $this->request->getPost('judul'),
            'deskripsi' => $this->request->getPost('deskripsi'),
            'tanggal'   => $this->request->getPost('tanggal'),
            'waktu'     => $this->request->getPost('waktu'),
            'tipe'      => $this->request->getPost('tipe'),
            'file'      => $namaFile,
        ]);

        return redirect()->to('/admin/aktivitas')->with('success', 'Aktivitas berhasil diperbarui');
    }

    // ===============================
    // HAPUS DATA
    // ===============================
    public function delete($id)
    {
        $act = $this->aktivitas->find($id);

        if ($act && $act['file'] && file_exists('img/activity/' . $act['file'])) {
            unlink('img/activity/' . $act['file']);
        }

        $this->aktivitas->delete($id);

        return redirect()->to('/admin/aktivitas')->with('success', 'Aktivitas berhasil dihapus');
    }
}
