<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreatePendidikan extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'sekolah' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'jurusan' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'jenjang' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
            ],
            'tahun_mulai' => [
                'type'       => 'YEAR',
                'null'       => true,
            ],
            'tahun_selesai' => [
                'type'       => 'YEAR',
                'null'       => true,
            ],
            'logo' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('pendidikan');
    }

    public function down()
    {
        $this->forge->dropTable('pendidikan');
    }
}
