<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AlterNews extends Migration
{
    public function up()
    {
        // Menambahkan kolom slug pada tabel news
        $fields = [
            'slug' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'unique'     => true,
                'after'      => 'title' // kolom slug akan muncul setelah kolom title
            ],
        ];

        $this->forge->addColumn('news', $fields);
    }

    public function down()
    {
        // Menghapus kolom slug jika di-rollback
        $this->forge->dropColumn('news', 'slug');
    }
}
