<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddTipeToAktivitas extends Migration
{
    public function up()
    {
        $fields = [
            'tipe' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'default'    => 'Foto',
                'after'      => 'deskripsi'
            ],
            'file' => [ // Adding file just in case it's named 'gambar' or missing
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
                'after'      => 'tipe'
            ]
        ];
        
        // Check if columns exist before adding to prevent duplicate error if re-run manually on existing schema
        // But Forge addColumn usually handles this or throws error. 
        // Better to just try adding 'tipe'.
        // If 'file' column already exists? 
        // I will rely on the user's error. The user ONLY complained about 'tipe'.
        // But earlier standard code often uses 'gambar'. 
        // Let's check if I can inspect the table info? No tool for that.
        
        // I will add 'tipe' column.
        $this->forge->addColumn('aktivitas', [
            'tipe' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'default'    => 'Foto'
            ]
        ]);
        
        // I'll also try to add 'file' but wrapped in try-catch in my head? No, migration is rigorous.
        // Let's assume 'file' is also missing if 'tipe' is missing, as these are new requirements for the "modern" look.
        // I'll check if I can get column names 
    }

    public function down()
    {
        $this->forge->dropColumn('aktivitas', 'tipe');
    }
}
