<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>

<div class="page-header-admin">
    <h1 class="page-title">Tambah Aktivitas</h1>
    <a href="<?= base_url('/admin/aktivitas') ?>" class="btn-add" style="background: #333;">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>
</div>

<form action="<?= base_url('/admin/aktivitas/store') ?>" method="post" enctype="multipart/form-data" class="admin-form-container">

    <!-- JUDUL -->
    <div class="form-group">
        <label class="form-label">Judul Aktivitas</label>
        <input type="text" name="judul" required class="admin-input">
    </div>

    <!-- DESKRIPSI -->
    <div class="form-group">
        <label class="form-label">Deskripsi</label>
        <textarea name="deskripsi" rows="4" class="admin-input"></textarea>
    </div>

    <!-- TANGGAL + WAKTU -->
    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
        <div>
            <label class="form-label">Tanggal</label>
            <input type="date" name="tanggal" required class="admin-input">
        </div>

        <div>
            <label class="form-label">Waktu</label>
            <input type="time" name="waktu" required value="<?= date('H:i') ?>" class="admin-input">
        </div>
    </div>

    <!-- TIPE -->
    <div class="form-group">
        <label class="form-label">Tipe Konten</label>
        <select name="tipe" class="admin-input">
            <option value="Foto">Foto</option>
            <option value="Video">Video</option>
        </select>
    </div>

    <!-- FILE -->
    <div class="form-group" style="margin-bottom: 30px;">
        <label class="form-label">Upload File (Foto / Thumbnail)</label>
        <input type="file" name="file" class="admin-input">
    </div>

    <button type="submit" class="btn-add" style="width: 100%; justify-content: center; padding: 14px;">
        Simpan Aktivitas
    </button>

</form>

<?= $this->endSection() ?>
