<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>

<div class="page-header-admin">
    <h1 class="page-title">Edit Aktivitas</h1>
    <a href="<?= base_url('/admin/aktivitas') ?>" class="btn-add" style="background:#333;">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>
</div>

<form
    action="<?= base_url('/admin/aktivitas/update/' . $act['id']) ?>"
    method="post"
    enctype="multipart/form-data"
    class="admin-form-container"
>

    <!-- JUDUL -->
    <div class="form-group">
        <label class="form-label">Judul Aktivitas</label>
        <input
            type="text"
            name="judul"
            value="<?= esc($act['judul']) ?>"
            required
            class="admin-input"
        >
    </div>

    <!-- DESKRIPSI -->
    <div class="form-group">
        <label class="form-label">Deskripsi</label>
        <textarea
            name="deskripsi"
            rows="4"
            class="admin-input"
        ><?= esc($act['deskripsi']) ?></textarea>
    </div>

    <!-- TANGGAL, WAKTU, TIPE -->
    <div style="display:grid;grid-template-columns:1fr 1fr 1fr;gap:20px;margin-bottom:20px;">

        <div>
            <label class="form-label">Tanggal</label>
            <input
                type="date"
                name="tanggal"
                value="<?= esc($act['tanggal']) ?>"
                required
                class="admin-input"
            >
        </div>

        <div>
            <label class="form-label">Waktu</label>
            <input
                type="time"
                name="waktu"
                value="<?= date('H:i', strtotime($act['waktu'])) ?>"
                required
                class="admin-input"
            >
        </div>

        <div>
            <label class="form-label">Tipe Konten</label>
            <select
                name="tipe"
                class="admin-input"
            >
                <option value="Foto" <?= $act['tipe'] === 'Foto' ? 'selected' : '' ?>>Foto</option>
                <option value="Video" <?= $act['tipe'] === 'Video' ? 'selected' : '' ?>>Video</option>
            </select>
        </div>

    </div>

    <!-- FILE -->
    <div class="form-group" style="margin-bottom:30px;">
        <label class="form-label">
            Ganti File (Biarkan kosong jika tidak diubah)
        </label>

        <div style="display:flex;gap:10px;align-items:center;">
            <img
                src="<?= base_url('img/activity/' . $act['file']) ?>"
                style="width:60px;height:60px;object-fit:cover;border-radius:8px;border:1px solid #333;"
            >
            <input
                type="file"
                name="file"
                class="admin-input"
                style="flex: 1;"
            >
        </div>
    </div>

    <!-- BUTTON -->
    <button
        type="submit"
        class="btn-add"
        style="width:100%;justify-content:center;padding:14px;"
    >
        Update Aktivitas
    </button>

</form>

<?= $this->endSection() ?>
