<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>

<div class="page-header-admin">
    <h1 class="page-title">Kelola Aktivitas</h1>
    <a href="<?= base_url('/admin/aktivitas/create') ?>" class="btn-add">
        <i class="fas fa-plus"></i> Tambah Baru
    </a>
</div>

<div class="table-responsive">
    <table class="admin-table">
        <thead>
            <tr>
                <th>#</th>
                <th>Thumbnail</th>
                <th>Judul Aktivitas</th>
                <th>Tipe</th>
                <th>Tanggal</th>
                <th>Waktu</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($aktivitas as $i => $act): ?>
            <tr>
                <td><?= $i + 1 ?></td>

                <td>
                    <img
                        src="<?= base_url('img/activity/' . $act['file']) ?>"
                        style="width:60px;height:40px;object-fit:cover;border-radius:6px;cursor:pointer;"
                        class="trigger-preview"
                        data-judul="<?= esc($act['judul']) ?>"
                        data-deskripsi="<?= esc($act['deskripsi']) ?>"
                        data-tanggal="<?= date('d M Y', strtotime($act['tanggal'])) ?>"
                        data-waktu="<?= date('H:i', strtotime($act['waktu'])) ?>"
                        data-tipe="<?= esc($act['tipe']) ?>"
                        data-file="<?= base_url('img/activity/' . $act['file']) ?>"
                    >
                </td>

                <td>
                    <div style="font-weight:600;color:#fff;cursor:pointer;" 
                         class="trigger-preview"
                         data-judul="<?= esc($act['judul']) ?>"
                         data-deskripsi="<?= esc($act['deskripsi']) ?>"
                         data-tanggal="<?= date('d M Y', strtotime($act['tanggal'])) ?>"
                         data-waktu="<?= date('H:i', strtotime($act['waktu'])) ?>"
                         data-tipe="<?= esc($act['tipe']) ?>"
                         data-file="<?= base_url('img/activity/' . $act['file']) ?>">
                        <?= esc($act['judul']) ?>
                    </div>
                    <small style="color:#666;">
                        <?= substr(esc($act['deskripsi']), 0, 50) ?>...
                    </small>
                </td>

                <td>
                    <?php if ($act['tipe'] === 'Video'): ?>
                        <span style="color:#ff4d61;font-weight:600;">
                            <i class="fas fa-video"></i> Video
                        </span>
                    <?php else: ?>
                        <span style="color:#28a745;font-weight:600;">
                            <i class="fas fa-image"></i> Foto
                        </span>
                    <?php endif; ?>
                </td>

                <td>
                    <?= esc($act['tanggal']) ?>
                </td>

                <td style="color:#aaa;">
                    <i class="far fa-clock"></i>
                    <?= date('H:i', strtotime($act['waktu'])) ?>
                </td>

                <td>
                    <button type="button" class="action-btn btn-preview trigger-preview"
                            data-judul="<?= esc($act['judul']) ?>"
                            data-deskripsi="<?= esc($act['deskripsi']) ?>"
                            data-tanggal="<?= date('d M Y', strtotime($act['tanggal'])) ?>"
                            data-waktu="<?= date('H:i', strtotime($act['waktu'])) ?>"
                            data-tipe="<?= esc($act['tipe']) ?>"
                            data-file="<?= base_url('img/activity/' . $act['file']) ?>"
                            style="background: rgba(0, 123, 255, 0.1); color: #007bff; border: none; cursor: pointer;">
                        Preview
                    </button>
                    <a href="<?= base_url('/admin/aktivitas/edit/' . $act['id']) ?>"
                       class="action-btn btn-edit">
                        Edit
                    </a>

                    <a href="<?= base_url('/admin/aktivitas/delete/' . $act['id']) ?>"
                       class="action-btn btn-delete"
                       onclick="return confirm('Yakin ingin menghapus?')">
                        Hapus
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- MODAL PREVIEW AKTIVITAS (IMMERSIVE) -->
<div id="activityModal" class="modal-overlay">
    <div class="modal-content">
        <div class="close-modal">&times;</div>
        <div class="modal-body">
            <div class="modal-visual">
                <img id="modalImg" src="" alt="" style="display: none;">
                <video id="modalVideo" controls style="display: none;"></video>
            </div>
            <div class="modal-info">
                <span id="modalBadge" class="modal-badge"></span>
                <div class="modal-date">
                    <i class="far fa-calendar-alt"></i>
                    <span id="modalTanggal"></span>
                    <span style="margin: 0 5px;">|</span>
                    <i class="far fa-clock"></i>
                    <span id="modalWaktu"></span>
                </div>
                <h2 id="modalTitle"></h2>
                <p id="modalDesc" class="modal-desc"></p>
            </div>
        </div>
    </div>
</div>

<script>
    const modal = document.getElementById('activityModal');
    const closeBtn = document.querySelector('.close-modal');
    const triggers = document.querySelectorAll('.trigger-preview');

    triggers.forEach(trigger => {
        trigger.addEventListener('click', () => {
            const data = trigger.dataset;
            
            // Populate data
            document.getElementById('modalTitle').innerText = data.judul;
            document.getElementById('modalDesc').innerText = data.deskripsi;
            document.getElementById('modalTanggal').innerText = data.tanggal;
            document.getElementById('modalWaktu').innerText = data.waktu;
            document.getElementById('modalBadge').innerText = data.tipe;
            
            const img = document.getElementById('modalImg');
            const video = document.getElementById('modalVideo');
            
            if (data.tipe === 'Video') {
                img.style.display = 'none';
                video.style.display = 'block';
                video.src = data.file;
            } else {
                video.style.display = 'none';
                video.src = '';
                img.style.display = 'block';
                img.src = data.file;
            }
            
            modal.classList.add('active');
            document.body.style.overflow = 'hidden';
        });
    });

    closeBtn.addEventListener('click', () => {
        modal.classList.remove('active');
        document.body.style.overflow = 'auto';
        document.getElementById('modalVideo').pause();
    });

    window.addEventListener('click', (e) => {
        if (e.target === modal) {
            modal.classList.remove('active');
            document.body.style.overflow = 'auto';
            document.getElementById('modalVideo').pause();
        }
    });
</script>

<?= $this->endSection() ?>
