<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>

<div class="page-header-admin">
    <h1 class="page-title">Kelola Pendidikan</h1>
    <a href="<?= base_url('/admin/pendidikan/create') ?>" class="btn-add">
        <i class="fas fa-plus"></i> Tambah Baru
    </a>
</div>

<div class="table-responsive">
    <table class="admin-table">
        <thead>
            <tr>
                <th>#</th>
                <th>Logo</th>
                <th>Sekolah / Universitas</th>
                <th>Jenjang</th>
                <th>Jurusan</th>
                <th>Tahun</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($pendidikan as $i => $edu): ?>
            <tr>
                <td><?= $i + 1 ?></td>
                <td>
                    <img src="<?= base_url('img/pendidikan/' . $edu['logo']) ?>" 
                         style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px; cursor: pointer;"
                         onerror="this.src='https://via.placeholder.com/50x50?text=No+Img'"
                         data-sekolah="<?= esc($edu['sekolah']) ?>"
                         data-jurusan="<?= esc($edu['jurusan']) ?>"
                         data-jenjang="<?= esc($edu['jenjang']) ?>"
                         data-tahun="<?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?>"
                         data-logo="<?= base_url('img/pendidikan/' . $edu['logo']) ?>"
                         onclick="previewEdu(this)">
                </td>
                <td>
                    <div style="font-weight: 600; color: #fff; cursor: pointer;" 
                         data-sekolah="<?= esc($edu['sekolah']) ?>"
                         data-jurusan="<?= esc($edu['jurusan']) ?>"
                         data-jenjang="<?= esc($edu['jenjang']) ?>"
                         data-tahun="<?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?>"
                         data-logo="<?= base_url('img/pendidikan/' . $edu['logo']) ?>"
                         onclick="previewEdu(this)">
                        <?= esc($edu['sekolah']) ?>
                    </div>
                </td>
                <td><span style="background: rgba(255,255,255,0.1); padding: 4px 8px; border-radius: 4px; font-size: 11px;"><?= esc($edu['jenjang']) ?></span></td>
                <td><?= esc($edu['jurusan']) ?></td>
                <td><?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?></td>
                <td>
                    <button type="button" class="action-btn btn-preview" 
                            data-sekolah="<?= esc($edu['sekolah']) ?>"
                            data-jurusan="<?= esc($edu['jurusan']) ?>"
                            data-jenjang="<?= esc($edu['jenjang']) ?>"
                            data-tahun="<?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?>"
                            data-logo="<?= base_url('img/pendidikan/' . $edu['logo']) ?>"
                            onclick="previewEdu(this)"
                            style="background: rgba(0, 123, 255, 0.1); color: #007bff; border: none; cursor: pointer;">
                        Preview
                    </button>
                    <a href="<?= base_url('/admin/pendidikan/edit/'.$edu['id']) ?>" class="action-btn btn-edit">Edit</a>
                    <a href="<?= base_url('/admin/pendidikan/delete/'.$edu['id']) ?>" class="action-btn btn-delete" onclick="return confirm('Yakin ingin menghapus?')">Hapus</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- MODAL PREVIEW EDUCATIONS -->
<div id="eduModal" class="modal-overlay">
    <div class="modal-content" style="max-width: 500px;">
        <div class="close-modal" onclick="closeEduModal()">&times;</div>
        <div style="padding: 40px; text-align: center;">
            <div style="width: 120px; height: 120px; margin: 0 auto 25px; background: #1a1a1a; border-radius: 50%; padding: 20px; border: 1px solid #333;">
                <img id="previewLogo" src="" style="width: 100%; height: 100%; object-fit: contain;">
            </div>
            <h2 id="previewSekolah" style="color: #fff; margin-bottom: 5px; font-size: 24px;"></h2>
            <div id="previewJenjang" style="display: inline-block; padding: 4px 12px; background: var(--marun); color: #fff; border-radius: 20px; font-size: 12px; margin-bottom: 20px;"></div>
            
            <table style="width: 100%; color: #888; text-align: left; border-top: 1px solid #222; margin-top: 20px; padding-top: 20px;">
                <tr>
                    <td style="padding: 10px 0;">Jurusan</td>
                    <td id="previewJurusan" style="color: #fff; text-align: right;"></td>
                </tr>
                <tr>
                    <td style="padding: 10px 0;">Periode</td>
                    <td id="previewTahun" style="color: #fff; text-align: right;"></td>
                </tr>
            </table>
        </div>
    </div>
</div>

<script>
function previewEdu(btn) {
    const data = btn.dataset;
    document.getElementById('previewLogo').src = data.logo;
    document.getElementById('previewSekolah').innerText = data.sekolah;
    document.getElementById('previewJenjang').innerText = data.jenjang;
    document.getElementById('previewJurusan').innerText = data.jurusan || '-';
    document.getElementById('previewTahun').innerText = data.tahun;
    
    document.getElementById('eduModal').classList.add('active');
}

function closeEduModal() {
    document.getElementById('eduModal').classList.remove('active');
}

// Close on click outside
window.onclick = function(event) {
    const modal = document.getElementById('eduModal');
    if (event.target == modal) {
        closeEduModal();
    }
}
</script>

<?= $this->endSection() ?>
