<?= $this->include('layout/header') ?>

<section class="page-header">
    <h1>Pendidikan</h1>
    <p>Riwayat pendidikan formal yang telah saya tempuh</p>
</section>

<!-- FILTER -->
<form method="get" class="education-filter">
    <input type="text" name="q" placeholder="Nama sekolah / jurusan"
           value="<?= esc($_GET['q'] ?? '') ?>">

    <select name="jenjang">
        <option value="Semua">Semua Jenjang</option>
        <option value="S1" <?= ($_GET['jenjang'] ?? '')=='S1'?'selected':'' ?>>S1</option>
        <option value="SMA" <?= ($_GET['jenjang'] ?? '')=='SMA'?'selected':'' ?>>SMA</option>
        <option value="SMP" <?= ($_GET['jenjang'] ?? '')=='SMP'?'selected':'' ?>>SMP</option>
        <option value="SD" <?= ($_GET['jenjang'] ?? '')=='SD'?'selected':'' ?>>SD</option>
        <option value="TK" <?= ($_GET['jenjang'] ?? '')=='TK'?'selected':'' ?>>TK</option>
    </select>

    <select name="urut">
        <option value="desc" <?= ($_GET['urut'] ?? '')=='desc'?'selected':'' ?>>
            Tahun lulus (desc)
        </option>
        <option value="asc" <?= ($_GET['urut'] ?? '')=='asc'?'selected':'' ?>>
            Tahun masuk (asc)
        </option>
    </select>

    <button type="submit">Terapkan</button>
</form>

<!-- GRID PENDIDIKAN -->
<section class="education-grid">
    <?php foreach ($pendidikan as $edu): ?>
        <div class="edu-card">
            <div class="edu-image">
                <img src="<?= base_url('img/edu/' . $edu['logo']) ?>" alt="<?= esc($edu['sekolah']) ?>">
                <span class="edu-badge <?= strtolower($edu['jenjang']) ?>">
                    <?= esc($edu['jenjang']) ?>
                </span>
            </div>

            <div class="edu-content">
                <h3><?= esc($edu['sekolah']) ?></h3>
                <p><?= esc($edu['jurusan']) ?></p>
                <span class="edu-year">
                    <?= esc($edu['tahun_mulai']) ?> – <?= esc($edu['tahun_selesai']) ?>
                </span>
            </div>
        </div>
    <?php endforeach ?>
</section>

<<section class="education-grid">

    <!-- CARD 1 -->
    <div class="edu-card">
        <div class="edu-image">
            <img src="<?= base_url('img/edu/yatsi.png') ?>">
            <span class="edu-badge s1">S1</span>
        </div>
        <div class="edu-content">
            <h3>Universitas Yatsi Madani</h3>
            <p>Ilmu Komputer</p>
            <span class="edu-year">2023 – 2027</span>
        </div>
    </div>

    <!-- CARD 2 -->
    <div class="edu-card">
        <div class="edu-image">
            <img src="<?= base_url('img/edu/sma.jpg') ?>">
            <span class="edu-badge sma">SMA</span>
        </div>
        <div class="edu-content">
            <h3>SMAN 19 Kabupaten Tangerang</h3>
            <p>IPS</p>
            <span class="edu-year">2019 – 2022</span>
        </div>
    </div>

    <!-- CARD 3 -->
    <div class="edu-card">
        <div class="edu-image">
            <img src="<?= base_url('img/edu/smp.png') ?>">
            <span class="edu-badge smp">SMP</span>
        </div>
        <div class="edu-content">
            <h3>SMP Negeri 2 Balaraja</h3>
            <p>Kelas A</p>
            <span class="edu-year">2016 – 2019</span>
        </div>
    </div>

    <!-- CARD 4 -->
    <div class="edu-card">
        <div class="edu-image">
            <img src="<?= base_url('img/edu/sd.png') ?>">
            <span class="edu-badge sd">SD</span>
        </div>
        <div class="edu-content">
            <h3>SDN Saga 6</h3>
            <p>Pendidikan Dasar</p>
            <span class="edu-year">2010 – 2016</span>
        </div>
    </div>

    <!-- CARD 5 -->
    <div class="edu-card">
        <div class="edu-image">
            <img src="<?= base_url('img/edu/TK.png') ?>">
            <span class="edu-badge TK">TK</span>
        </div>
        <div class="edu-content">
            <h3>TK Adalia</h3>
            <p>Taman Kanak-Kanak</p>
            <span class="edu-year">2008 – 2009</span>
        </div>
    </div>

</section>

<!-- PAGINATION -->
<div class="pagination">
    <?= $pager->links('default', 'default_full') ?>
</div>

<?= $this->include('layout/footer') ?>
