<?php namespace App\Controllers;

use \App\Models\DailyActivityModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class ActivitiesAdmin extends BaseController
{
	public function index()
	{
		$model = new DailyActivityModel();
		
		// Get search parameter
		$search = $this->request->getGet('search');
		
		// Get filter parameters
		$filter_tanggal = $this->request->getGet('filter_tanggal');
		
		// Get sorting parameters
		$sort_by = $this->request->getGet('sort_by') ?? 'tanggal';
		$sort_order = $this->request->getGet('sort_order') ?? 'DESC';
		
		// Apply search
		if (!empty($search)) {
			$model->like('nama_aktivitas', $search);
		}
		
		// Apply filter
		if (!empty($filter_tanggal)) {
			$model->where('tanggal', $filter_tanggal);
		}
		
		// Apply sorting
		$model->orderBy($sort_by, $sort_order);
		
		$data = [
			'activities' => $model->paginate(10),
			'pager' => $model->pager,
			'search' => $search,
			'filter_tanggal' => $filter_tanggal,
			'sort_by' => $sort_by,
			'sort_order' => $sort_order,
		];
		
		echo view('admin/admin_list_activities', $data);
	}

	//--------------------------------------------------------------------------

	public function preview($id)
	{
		$model = new DailyActivityModel();
		$data['activity'] = $model->where('id', $id)->first();
		
		if(!$data['activity']){
			throw PageNotFoundException::forPageNotFound();
		}
		echo view('admin/admin_view_activity', $data);
	}

	//--------------------------------------------------------------------------

	public function create()
	{
		// lakukan validasi
		$validation =  \Config\Services::validation();
		$validation->setRules([
			'tanggal' => 'required',
			'jam' => 'required',
			'nama_aktivitas' => 'required'
		]);
		$isDataValid = $validation->withRequest($this->request)->run();

		// jika data valid, simpan ke database
		if($isDataValid){
			$model = new DailyActivityModel();
			
			// Handle file upload for foto
			$foto = '';
			$fileFoto = $this->request->getFile('foto');
			if ($fileFoto && $fileFoto->isValid() && !$fileFoto->hasMoved()) {
				$newName = $fileFoto->getRandomName();
				$fileFoto->move(WRITEPATH . '../public/uploads/', $newName);
				$foto = 'uploads/' . $newName;
			}
			
			// Handle file upload for video
			$video = '';
			$fileVideo = $this->request->getFile('video');
			if ($fileVideo && $fileVideo->isValid() && !$fileVideo->hasMoved()) {
				$newName = $fileVideo->getRandomName();
				$fileVideo->move(WRITEPATH . '../public/uploads/', $newName);
				$video = 'uploads/' . $newName;
			}
			
			$model->insert([
				"tanggal" => $this->request->getPost('tanggal'),
				"jam" => $this->request->getPost('jam'),
				"nama_aktivitas" => $this->request->getPost('nama_aktivitas'),
				"foto" => $foto,
				"video" => $video
			]);
			return redirect('admin/activities');
		}
		
		// tampilkan form create
		echo view('admin/admin_create_activity');
	}

	//--------------------------------------------------------------------------

	public function edit($id)
	{
		// ambil data yang akan diedit
		$model = new DailyActivityModel();
		$data['activity'] = $model->where('id', $id)->first();
		
		// lakukan validasi data
		$validation =  \Config\Services::validation();
		$validation->setRules([
			'id' => 'required',
			'tanggal' => 'required',
			'jam' => 'required',
			'nama_aktivitas' => 'required'
		]);
		$isDataValid = $validation->withRequest($this->request)->run();
		
		// jika data valid, maka simpan ke database
		if($isDataValid){
			$updateData = [
				"tanggal" => $this->request->getPost('tanggal'),
				"jam" => $this->request->getPost('jam'),
				"nama_aktivitas" => $this->request->getPost('nama_aktivitas')
			];
			
			// Handle file upload for foto
			$fileFoto = $this->request->getFile('foto');
			if ($fileFoto && $fileFoto->isValid() && !$fileFoto->hasMoved()) {
				// Delete old foto if exists
				if (!empty($data['activity']['foto'])) {
					$oldFile = WRITEPATH . '../public/' . $data['activity']['foto'];
					if (file_exists($oldFile)) {
						unlink($oldFile);
					}
				}
				$newName = $fileFoto->getRandomName();
				$fileFoto->move(WRITEPATH . '../public/uploads/', $newName);
				$updateData['foto'] = 'uploads/' . $newName;
			}
			
			// Handle file upload for video
			$fileVideo = $this->request->getFile('video');
			if ($fileVideo && $fileVideo->isValid() && !$fileVideo->hasMoved()) {
				// Delete old video if exists
				if (!empty($data['activity']['video'])) {
					$oldFile = WRITEPATH . '../public/' . $data['activity']['video'];
					if (file_exists($oldFile)) {
						unlink($oldFile);
					}
				}
				$newName = $fileVideo->getRandomName();
				$fileVideo->move(WRITEPATH . '../public/uploads/', $newName);
				$updateData['video'] = 'uploads/' . $newName;
			}
			
			$model->update($id, $updateData);
			return redirect('admin/activities');
		}

		// tampilkan form edit
		echo view('admin/admin_edit_activity', $data);
	}

	//--------------------------------------------------------------------------

	public function delete($id){
		$model = new DailyActivityModel();
		$activity = $model->where('id', $id)->first();
		
		// Delete files if exist
		if (!empty($activity['foto'])) {
			$file = WRITEPATH . '../public/' . $activity['foto'];
			if (file_exists($file)) {
				unlink($file);
			}
		}
		if (!empty($activity['video'])) {
			$file = WRITEPATH . '../public/' . $activity['video'];
			if (file_exists($file)) {
				unlink($file);
			}
		}
		
		$model->delete($id);
		return redirect()->to(base_url('admin/activities'));
	}
}

