<?php
$uri = service('uri');
$segment1 = $uri->getSegment(1) ?: 'home';
$isHome = ($segment1 === 'home' || $segment1 === '');

$pages = [
    'home' => [
        'eyebrow'  => 'SELAMAT DATANG',
        'title'    => 'Halo, Saya Anggita Rahmania',
        'subtitle' => 'Creative Developer & Designer',
        'desc'     => 'Selamat datang di ruang digital saya. Di sini, saya memadukan estetika desain dengan logika kode untuk menciptakan pengalaman web yang memukau dan fungsional. Mari jelajahi karya dan perjalanan saya.',
        'cta_main' => ['label' => 'Jelajahi Karya',   'href' => base_url('activities#main-content')],
        'cta_alt'  => ['label' => 'Tentang Saya',     'href' => base_url('biodata')],
        'cta_soft' => ['label' => 'Kontak',           'href' => base_url('contact')],
        'initials' => 'AR',
    ],
    'activities' => [
        'eyebrow'  => 'JURNAL HARIAN',
        'title'    => 'Kreativitas & Produktivitas',
        'subtitle' => 'Menjalani Hari dengan Penuh Semangat',
        'desc'     => 'Kumpulan momen berharga, progres belajar, dan kegiatan sehari-hari yang membentuk perjalanan karir saya.',
        'cta_main' => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities#main-content')],
        'cta_alt'  => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'cta_soft' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education')],
        'initials' => 'AR',
    ],
    'biodata' => [
        'eyebrow'  => 'TENTANG SAYA',
        'title'    => 'Pribadi & Keahlian',
        'subtitle' => 'Mengenal Lebih Dalam',
        'desc'     => 'Informasi lengkap mengenai latar belakang, pengalaman profesional, serta kemampuan teknis yang saya kembangkan dengan penuh dedikasi.',
        'cta_main' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education')],
        'initials' => 'BD',
    ],
    'education' => [
        'eyebrow'  => 'AKADEMIS',
        'title'    => 'Rekam Jejak Pendidikan',
        'subtitle' => 'Fondasi Pengetahuan & Karir',
        'desc'     => 'Riwayat pendidikan formal yang telah ditempuh, mencakup gelar, jurusan, dan pencapaian akademis yang mendukung profesionalisme saya.',
        'cta_main' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'initials' => 'AR',
    ],
    'about' => [
        'eyebrow'  => 'Tentang Saya',
        'title'    => 'Sekilas Cerita',
        'subtitle' => 'Halaman sederhana',
        'desc'     => 'Halaman singkat yang menjelaskan profil dan tujuan pembuatan aplikasi.',
        'cta_main' => ['label' => 'Pelajari',         'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'initials' => 'AB',
    ],
    'contact' => [
        'eyebrow'  => 'Kontak',
        'title'    => 'Mari Terhubung',
        'subtitle' => 'Siap diajak diskusi',
        'desc'     => 'Hubungi saya melalui informasi kontak berikut.',
        'cta_main' => ['label' => 'Hubungi',          'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Pendidikan', 'href' => base_url('education')],
        'initials' => 'CT',
    ],
    'faqs' => [
        'eyebrow'  => 'Pertanyaan Umum',
        'title'    => 'Jawaban Singkat',
        'subtitle' => 'FAQ',
        'desc'     => 'Jawaban singkat untuk pertanyaan yang sering diajukan.',
        'cta_main' => ['label' => 'Baca FAQ',         'href' => base_url('#main-content')],
        'cta_alt'  => ['label' => 'Lihat Aktivitas',  'href' => base_url('activities')],
        'cta_soft' => ['label' => 'Lihat Biodata',    'href' => base_url('biodata')],
        'initials' => 'FQ',
    ],
];

$page = $pages[$segment1] ?? $pages['activities'];
?>
<div class="hero-wrap">
    <div class="container hero-grid">
        <div class="hero-copy">
            <div class="hero-eyebrow"><?= esc($page['eyebrow']) ?></div>
            <h1 class="hero-title"><?= esc($page['title']) ?></h1>
            <?php if (!empty($page['subtitle'])): ?>
                <p class="hero-subtitle"><?= esc($page['subtitle']) ?></p>
            <?php endif; ?>
            <p class="hero-desc"><?= esc($page['desc']) ?></p>
            
            <?php if(isset($page['cta_main'])): ?>
            <div class="hero-actions" style="opacity: 0; animation: fadeUp 0.8s ease-out 0.8s forwards; margin-top: 2rem;">
                <a href="<?= $page['cta_main']['href'] ?>" class="btn-solid" style="border-radius: 50px; padding: 1rem 2rem; font-weight: 600;">Let's Explore</a>
            </div>
            <?php endif; ?>
        </div>
        <!-- Hero visual removed as requested -->
    </div>

    <?php if ($isHome): ?>
        <!-- Feature grid removed as requested -->
    <?php endif; ?>
</div>
