<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->get('/activities', 'Home::activities');
$routes->get('/biodata', 'Home::biodata');
$routes->get('/education', 'Home::education');


$routes->get('/login', 'Auth::login');
$routes->post('/login', 'Auth::attemptLogin');
$routes->get('/logout', 'Auth::logout');
$routes->get('/debug', 'Debug::index');

$routes->group('admin', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'Admin\Dashboard::index');

    // Activity
    $routes->post('biodata/update/(:num)', 'Admin\Biodata::update/$1');
    $routes->resource('activity', ['controller' => 'Admin\Activity']);

    // Biodata
    $routes->resource('biodata', ['controller' => 'Admin\Biodata']);

    // Education
    $routes->resource('education', ['controller' => 'Admin\Education']);
});
