<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">Tambah Aktivitas</h2>

    <form action="/admin/activity" method="post" enctype="multipart/form-data">
        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Tanggal</label>
            <input type="date" name="date" value="<?= old('date') ?>"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Jam</label>
            <input type="time" name="time" value="<?= old('time') ?>"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Nama Aktivitas</label>
            <textarea name="activity_name" rows="3"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none"><?= old('activity_name') ?></textarea>
        </div>

        <div class="mb-6">
            <label class="block text-gray-700 font-medium mb-2">Foto / Video</label>
            <input type="file" name="file_upload" class="w-full border p-2 rounded bg-gray-50">
            <p class="text-gray-500 text-xs mt-1">Format: JPG, PNG, MP4. Max 10MB.</p>
        </div>

        <div class="flex justify-end gap-2">
            <a href="/admin/activity" class="px-4 py-2 text-gray-600 hover:bg-gray-100 rounded">Batal</a>
            <button type="submit"
                class="px-6 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 shadow">Simpan</button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>