<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-gray-800">Manajemen Aktivitas Harian</h1>
    <a href="/admin/activity/new"
        class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded shadow transition">
        + Tambah Baru
    </a>
</div>

<!-- Search & Filter -->
<div class="bg-white p-4 rounded-lg shadow mb-6">
    <form action="" method="get" class="flex items-center gap-4">
        <input type="text" name="search" value="<?= esc($search) ?>" class="border rounded px-4 py-2 w-full md:w-1/3"
            placeholder="Cari aktivitas...">
        <select name="sort" class="border rounded px-4 py-2">
            <option value="id" <?= $sort == 'id' ? 'selected' : '' ?>>ID</option>
            <option value="date" <?= $sort == 'date' ? 'selected' : '' ?>>Tanggal</option>
            <option value="activity_name" <?= $sort == 'activity_name' ? 'selected' : '' ?>>Nama</option>
        </select>
        <select name="order" class="border rounded px-4 py-2">
            <option value="ASC" <?= $order == 'ASC' ? 'selected' : '' ?>>ASC</option>
            <option value="DESC" <?= $order == 'DESC' ? 'selected' : '' ?>>DESC</option>
        </select>
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded hover:bg-gray-700">Filter</button>
    </form>
</div>

<!-- Table -->
<div class="bg-white rounded-lg shadow overflow-hidden">
    <table class="w-full text-left border-collapse">
        <thead class="bg-gray-100 text-gray-700 uppercase text-sm">
            <tr>
                <th class="p-4 border-b">Tanggal</th>
                <th class="p-4 border-b">Jam</th>
                <th class="p-4 border-b">Nama Aktivitas</th>
                <th class="p-4 border-b">Media</th>
                <th class="p-4 border-b text-right">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($activities as $item): ?>
                <tr class="hover:bg-gray-50">
                    <td class="p-4 border-b"><?= $item['date'] ?></td>
                    <td class="p-4 border-b"><?= $item['time'] ?></td>
                    <td class="p-4 border-b font-medium text-gray-900"><?= esc($item['activity_name']) ?></td>
                    <td class="p-4 border-b">
                        <?php if ($item['media_path']): ?>
                            <a href="/uploads/activities/<?= $item['media_path'] ?>" target="_blank"
                                class="text-blue-600 underline text-xs">Lihat Media</a>
                        <?php else: ?>
                            <span class="text-gray-400 text-xs">-</span>
                        <?php endif; ?>
                    </td>
                    <td class="p-4 border-b text-right space-x-2">
                        <a href="/admin/activity/<?= $item['id'] ?>/edit"
                            class="text-blue-600 hover:text-blue-800 font-medium">Edit</a>
                        <form action="/admin/activity/<?= $item['id'] ?>" method="post" class="inline-block"
                            onsubmit="return confirm('Yakin hapus?');">
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit"
                                class="text-red-600 hover:text-red-800 font-medium bg-transparent border-0 cursor-pointer">Hapus</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <?php if (empty($activities)): ?>
        <div class="p-8 text-center text-gray-500">Data tidak ditemukan.</div>
    <?php endif; ?>
</div>

<div class="mt-6 flex justify-center">
    <?= $pager->links() ?>
</div>

<?= $this->endSection() ?>