<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<?php if (empty($biodata)): ?>
    <div class="flex flex-col items-center justify-center py-24 px-4 text-center">
        <div class="w-32 h-32 bg-primary-50 rounded-full flex items-center justify-center mb-6">
            <span class="text-6xl grayscale opacity-30">👤</span>
        </div>
        <h2 class="text-3xl font-extrabold text-gray-900 tracking-tight mb-2">Belum Ada Data</h2>
        <p class="text-gray-500 max-w-md">Data biodata atau CV belum tersedia saat ini.</p>
    </div>
<?php else: ?>
    <div class="space-y-24 pb-20">
        <?php foreach ($biodata as $item): ?>
            <!-- Profile Hero Card -->
            <div class="relative w-full max-w-5xl mx-auto">
                <!-- Decorative Top Banner -->
                <div
                    class="h-64 w-full bg-gradient-to-r from-primary-800 to-blue-600 rounded-t-3xl shadow-lg relative overflow-hidden">
                    <div
                        class="absolute top-0 right-0 w-96 h-96 bg-white opacity-10 rounded-full blur-3xl -mr-32 -mt-32 mix-blend-overlay">
                    </div>
                    <div
                        class="absolute bottom-0 left-0 w-72 h-72 bg-sky-400 opacity-20 rounded-full blur-2xl -ml-20 -mb-20 mix-blend-overlay">
                    </div>
                </div>

                <!-- Main Content Container -->
                <div
                    class="bg-white rounded-b-3xl shadow-2xl relative -mt-0 z-10 mx-0 border-x border-b border-primary-50/50 pb-12">

                    <!-- Floating Profile Picture -->
                    <div class="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                        <div class="relative group">
                            <div
                                class="absolute inset-0 bg-gradient-to-br from-primary-400 to-sky-400 rounded-full blur opacity-75 group-hover:opacity-100 transition duration-500">
                            </div>
                            <div class="w-48 h-48 rounded-full p-1.5 bg-white relative z-10 shadow-xl overflow-hidden">
                                <?php if (!empty($item['photo'])): ?>
                                    <img src="/uploads/biodata/<?= esc($item['photo']) ?>" alt="<?= esc($item['name']) ?>"
                                        class="w-full h-full object-cover rounded-full hover:scale-110 transition-transform duration-700">
                                <?php else: ?>
                                    <div
                                        class="w-full h-full bg-primary-50 flex items-center justify-center text-8xl text-primary-200">
                                        👤
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="absolute bottom-4 right-4 w-10 h-10 bg-green-500 border-4 border-white rounded-full z-20 shadow-md content-center text-center text-white font-bold text-sm pt-0.5"
                                title="Open to Work">✓</div>
                        </div>
                    </div>

                    <!-- Profile Info -->
                    <div class="pt-28 px-8 sm:px-12 text-center">
                        <h1 class="text-4xl sm:text-5xl font-extrabold text-gray-900 tracking-tight mb-3">
                            <?= esc($item['name']) ?>
                        </h1>
                        <p class="text-xl text-primary-500 font-medium mb-8">Sandra Aulia</p>

                        <!-- Social/Contact Pills -->
                        <div class="flex flex-wrap justify-center gap-4 mb-10">
                            <a href="mailto:<?= esc($item['email']) ?>"
                                class="group flex items-center gap-3 px-6 py-3 bg-white border border-gray-200 rounded-full shadow-sm hover:shadow-md hover:border-primary-300 transition-all duration-300">
                                <span
                                    class="bg-primary-50 p-2 rounded-full text-primary-600 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                                    📧
                                </span>
                                <span
                                    class="text-gray-600 font-medium group-hover:text-primary-700"><?= esc($item['email']) ?></span>
                            </a>
                            <a href="tel:<?= esc($item['phone']) ?>"
                                class="group flex items-center gap-3 px-6 py-3 bg-white border border-gray-200 rounded-full shadow-sm hover:shadow-md hover:border-primary-300 transition-all duration-300">
                                <span
                                    class="bg-primary-50 p-2 rounded-full text-primary-600 group-hover:bg-primary-600 group-hover:text-white transition-colors">
                                    📱
                                </span>
                                <span
                                    class="text-gray-600 font-medium group-hover:text-primary-700"><?= esc($item['phone']) ?></span>
                            </a>
                        </div>

                        <!-- Divider -->
                        <div class="w-24 h-1 bg-gradient-to-r from-primary-200 to-blue-200 mx-auto rounded-full mb-10"></div>

                        <!-- About & Details Grid -->
                        <div class="grid grid-cols-1 lg:grid-cols-3 gap-12 text-left">
                            <!-- About Me Column -->
                            <div class="lg:col-span-2 space-y-6">
                                <h3 class="text-2xl font-bold text-gray-800 flex items-center gap-3">
                                    <span class="bg-sky-100 text-sky-600 p-2 rounded-lg text-lg">📝</span>
                                    Tentang Saya
                                </h3>
                                <div
                                    class="prose prose-lg prose-sky text-gray-600 leading-relaxed font-light bg-primary-50/30 p-8 rounded-3xl border border-primary-50/50">
                                    <?= nl2br(esc($item['summary'])) ?>
                                </div>
                            </div>

                            <!-- Details Column -->
                            <div class="space-y-6">
                                <h3 class="text-2xl font-bold text-gray-800 flex items-center gap-3">
                                    <span class="bg-sky-100 text-sky-600 p-2 rounded-lg text-lg">📍</span>
                                    Detail Info
                                </h3>
                                <div
                                    class="bg-white rounded-3xl shadow-lg p-8 border border-gray-100 flex flex-col gap-6 relative overflow-hidden group">
                                    <div class="absolute top-0 right-0 w-32 h-32 bg-primary-50 rounded-bl-full -mr-8 -mt-8 z-0">
                                    </div>

                                    <div class="relative z-10 space-y-4">
                                        <div>
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider block mb-1">Alamat
                                                Domisili</span>
                                            <p class="text-lg font-semibold text-gray-800 leading-snug">
                                                <?= esc($item['address']) ?>
                                            </p>
                                        </div>
                                        
                                        <?php if (!empty($item['birth_date'])): ?>
                                        <div>
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider block mb-1">Tanggal Lahir</span>
                                            <p class="text-lg font-semibold text-gray-800 leading-snug">
                                                <?= date('d F Y', strtotime($item['birth_date'])) ?>
                                            </p>
                                        </div>
                                        <?php endif; ?>

                                        <?php if (!empty($item['last_education'])): ?>
                                        <div>
                                            <span class="text-xs font-bold text-gray-400 uppercase tracking-wider block mb-1">Pendidikan Terakhir</span>
                                            <p class="text-lg font-semibold text-gray-800 leading-snug">
                                                <?= esc($item['last_education']) ?>
                                            </p>
                                        </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="relative z-10 w-full pt-6 border-t border-gray-100">
                                        <button
                                            class="w-full py-3 bg-gradient-to-r from-primary-600 to-blue-600 text-white rounded-xl font-bold shadow-lg shadow-primary-200 hover:shadow-xl hover:scale-[1.02] transition-all duration-300">
                                            Download CV
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>