<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Aul Admin - Portfolio</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        }
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>

<body class="bg-primary-50">

    <div class="flex min-h-screen">
        <!-- Sidebar -->
        <aside class="w-64 bg-white border-r border-primary-100 hidden md:block">
            <div class="p-6">
                <h2
                    class="text-2xl font-extrabold text-transparent bg-clip-text bg-gradient-to-r from-primary-600 to-blue-600">
                    Aul Admin
                </h2>
            </div>
            <nav class="mt-4">
                <a href="/admin"
                    class="flex items-center px-6 py-3 text-gray-700 hover:bg-primary-50 hover:text-primary-600 transition <?= uri_string() == 'admin' ? 'bg-primary-50 text-primary-600 font-bold border-r-4 border-primary-500' : '' ?>">
                    <span class="mr-3">📊</span> Dashboard
                </a>
                <a href="/admin/activity"
                    class="flex items-center px-6 py-3 text-gray-700 hover:bg-primary-50 hover:text-primary-600 transition <?= strpos(uri_string(), 'activity') !== false ? 'bg-primary-50 text-primary-600 font-bold border-r-4 border-primary-500' : '' ?>">
                    <span class="mr-3">📅</span> Aktivitas Harian
                </a>
                <a href="/admin/biodata"
                    class="flex items-center px-6 py-3 text-gray-700 hover:bg-primary-50 hover:text-primary-600 transition <?= strpos(uri_string(), 'biodata') !== false ? 'bg-primary-50 text-primary-600 font-bold border-r-4 border-primary-500' : '' ?>">
                    <span class="mr-3">👤</span> Biodata
                </a>
                <a href="/admin/education"
                    class="flex items-center px-6 py-3 text-gray-700 hover:bg-primary-50 hover:text-primary-600 transition <?= strpos(uri_string(), 'education') !== false ? 'bg-primary-50 text-primary-600 font-bold border-r-4 border-primary-500' : '' ?>">
                    <span class="mr-3">🎓</span> Pendidikan
                </a>

                <div class="border-t border-gray-100 mt-6 pt-6 px-6">
                    <a href="/logout" class="flex items-center text-red-500 hover:text-red-700 font-medium">
                        <span class="mr-3">🚪</span> Logout
                    </a>
                </div>
            </nav>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col">
            <!-- Mobile Header -->
            <header class="bg-white border-b border-primary-100 p-4 md:hidden flex justify-between items-center">
                <span class="font-bold text-primary-600">Admin Panel</span>
                <button class="text-gray-500 focus:outline-none">
                    ☰
                </button>
            </header>

            <!-- Content Area -->
            <main class="flex-1 p-6 md:p-10 overflow-y-auto">
                <div class="max-w-7xl mx-auto">
                    <!-- Flash Messages -->
                    <?php if (session()->getFlashdata('message')): ?>
                        <div
                            class="mb-6 bg-green-50 text-green-700 p-4 rounded-xl border border-green-200 flex items-center shadow-sm">
                            <span class="mr-2 text-xl">✅</span>
                            <?= session()->getFlashdata('message') ?>
                        </div>
                    <?php endif; ?>
                    <?php if (session()->getFlashdata('error')): ?>
                        <div
                            class="mb-6 bg-red-50 text-red-700 p-4 rounded-xl border border-red-200 flex items-center shadow-sm">
                            <span class="mr-2 text-xl">⚠️</span>
                            <?= session()->getFlashdata('error') ?>
                        </div>
                    <?php endif; ?>

                    <?= $this->renderSection('content') ?>
                </div>
            </main>
        </div>
    </div>

</body>

</html>