<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portfolio - <?= isset($title) ? $title : 'Welcome' ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        }
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }

        .glass-nav {
            background: rgba(255, 255, 255, 0.7);
            backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.5);
        }
    </style>
</head>

<body
    class="bg-primary-50 text-gray-800 antialiased min-h-screen flex flex-col selection:bg-primary-200 selection:text-primary-900">

    <!-- Navbar -->
    <div class="fixed w-full z-50 top-4 px-4 font-medium"> <!-- Floating Pill Navbar Container -->
        <nav class="glass-nav max-w-5xl mx-auto rounded-full shadow-lg transition-all duration-300">
            <div class="px-6 sm:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <a href="/"
                            class="text-2xl font-bold text-primary-600 tracking-tight hover:scale-105 transition-transform">
                            Aul<span class="text-primary-300">.Portfolio</span>
                        </a>
                    </div>
                    <div class="hidden md:flex space-x-1 items-center">
                        <a href="/"
                            class="px-4 py-2 rounded-full hover:bg-primary-50 text-gray-600 hover:text-primary-600 transition <?= ($active_tab ?? '') == 'home' ? 'text-primary-600 font-bold bg-white shadow-sm' : '' ?>">Beranda</a>
                        <a href="/activities"
                            class="px-4 py-2 rounded-full hover:bg-primary-50 text-gray-600 hover:text-primary-600 transition <?= ($active_tab ?? '') == 'activities' ? 'text-primary-600 font-bold bg-white shadow-sm' : '' ?>">Aktivitas</a>
                        <a href="/biodata"
                            class="px-4 py-2 rounded-full hover:bg-primary-50 text-gray-600 hover:text-primary-600 transition <?= ($active_tab ?? '') == 'biodata' ? 'text-primary-600 font-bold bg-white shadow-sm' : '' ?>">Biodata</a>
                        <a href="/education"
                            class="px-4 py-2 rounded-full hover:bg-primary-50 text-gray-600 hover:text-primary-600 transition <?= ($active_tab ?? '') == 'education' ? 'text-primary-600 font-bold bg-white shadow-sm' : '' ?>">Pendidikan</a>
                    </div>
                    <div class="flex items-center">
                        <a href="/admin"
                            class="px-5 py-2.5 bg-gradient-to-r from-primary-500 to-primary-600 text-white rounded-full shadow-md hover:shadow-lg hover:from-primary-600 hover:to-primary-700 transition duration-150 transform hover:-translate-y-0.5 text-sm font-semibold">
                            Login
                        </a>
                    </div>
                </div>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <main class="flex-grow pt-32 px-4 sm:px-6 lg:px-8 max-w-7xl mx-auto w-full">
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Footer -->
    <footer class="bg-white border-t border-primary-100 mt-20 pt-12 pb-8">
        <div class="max-w-7xl mx-auto px-4 text-center">
            <div class="mb-6">
                <a href="/" class="text-2xl font-bold text-gray-300 hover:text-primary-400 transition">Aul.</a>
            </div>
            <p class="text-gray-500 mb-6">
                Thank you for visiting my personal portfolio.<br>Let's create something beautiful together.
            </p>
            <div class="flex justify-center gap-6 mb-8">
                <!-- Social Placeholders -->
                <a href="#"
                    class="w-10 h-10 rounded-full bg-primary-50 text-primary-500 flex items-center justify-center hover:bg-primary-500 hover:text-white transition-all">📷</a>
                <a href="#"
                    class="w-10 h-10 rounded-full bg-primary-50 text-primary-500 flex items-center justify-center hover:bg-primary-500 hover:text-white transition-all">💼</a>
                <a href="#"
                    class="w-10 h-10 rounded-full bg-primary-50 text-primary-500 flex items-center justify-center hover:bg-primary-500 hover:text-white transition-all">🐦</a>
            </div>
            <div class="text-xs text-gray-400">
                &copy; 2024 Aul. All rights reserved. Built with <span
                    class="text-primary-500 font-bold">CodeIgniter 4</span>.
            </div>
        </div>
    </footer>

</body>

</html>