<?php

namespace App\Controllers\Admin;

use CodeIgniter\RESTful\ResourceController;
use App\Models\ActivityModel;

class ActivityController extends ResourceController
{
    protected $modelName = 'App\Models\ActivityModel';
    protected $format    = 'json';

    public function index()
    {
        helper('text');
        $search = $this->request->getGet('search');
        $filter = $this->request->getGet('filter'); // New Filter
        $sort = $this->request->getGet('sort') ?? 'date';
        $order = $this->request->getGet('order') ?? 'DESC';

        $model = new ActivityModel();

        if ($search) {
            if (strlen($search) >= 3) {
                $model->groupStart()
                    ->like('activity_name', $search)
                    ->orLike('description', $search)
                ->groupEnd();
            } else {
                session()->setFlashdata('warning', 'Kata kunci pencarian minimal 3 karakter.');
            }
        }

        // Apply Filter
        if ($filter) {
            if ($filter == 'photo') {
                $model->where('media_type', 'photo');
            } elseif ($filter == 'video') {
                $model->where('media_type', 'video');
            } elseif ($filter == 'none') {
                 $model->where('media_type', 'none'); // Assuming 'none' or NULL based on DB
            }
        }

        $data = [
            'activities' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'filter' => $filter, // Pass to view
            'sort' => $sort,
            'order' => $order,
            'title' => 'Daftar Aktivitas'
        ];

        return view('admin/activity/index', $data);
    }

    public function new()
    {
        return view('admin/activity/form', ['title' => 'Tambah Aktivitas']);
    }

    public function create()
    {
        $rules = [
            'date' => 'required|valid_date',
            'activity_name' => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = $this->request->getPost();
        
        // Handle Media Upload
        $media = $this->request->getFile('media_path');
        if ($media && $media->isValid() && !$media->hasMoved()) {
            $newName = $media->getRandomName();
            $media->move(FCPATH . 'uploads/activities', $newName);
            $data['media_path'] = 'uploads/activities/' . $newName;
        }

        $this->model->insert($data);
        return redirect()->to('/admin/activity')->with('message', 'Aktivitas berhasil ditambahkan');
    }

    public function edit($id = null)
    {
        $data = [
            'activity' => $this->model->find($id),
            'title' => 'Edit Aktivitas'
        ];
        return view('admin/activity/form', $data);
    }

    public function update($id = null)
    {
        $rules = [
            'date' => 'required|valid_date',
            'activity_name' => 'required',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = $this->request->getPost();

        // Handle Media Upload
        $media = $this->request->getFile('media_path');
        if ($media && $media->isValid() && !$media->hasMoved()) {
            $newName = $media->getRandomName();
            $media->move(FCPATH . 'uploads/activities', $newName);
            $data['media_path'] = 'uploads/activities/' . $newName;
        }

        $this->model->update($id, $data);
        return redirect()->to('/admin/activity')->with('message', 'Aktivitas berhasil diperbarui');
    }

    public function delete($id = null)
    {
        $this->model->delete($id);
        return redirect()->to('/admin/activity')->with('message', 'Aktivitas berhasil dihapus');
    }
}
