<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ProfileModel;
use App\Models\EducationModel;
use App\Models\ActivityModel;

class DashboardController extends BaseController
{
    public function index()
    {
        $profileModel = new ProfileModel();
        $educationModel = new EducationModel();
        $activityModel = new ActivityModel();

        // Chart Data: Media Type Distribution
        $photoCount = $activityModel->where('media_type', 'photo')->countAllResults();
        $videoCount = $activityModel->where('media_type', 'video')->countAllResults();

        // Recent Updates
        $recentActivities = $activityModel->orderBy('date', 'DESC')->orderBy('time', 'DESC')->findAll(5);

        $data = [
            'title' => 'Dasbor Admin',
            'counts' => [
                'profiles'   => $profileModel->countAll(),
                'educations' => $educationModel->countAll(),
                'activities' => $activityModel->countAll(),
            ],
            'chart_data' => [
                'photo' => $photoCount,
                'video' => $videoCount
            ],
            'recent_activities' => $recentActivities
        ];

        return view('admin/dashboard/index', $data);
    }
}
