<?php

namespace App\Controllers\Admin;

use CodeIgniter\RESTful\ResourceController;
use App\Models\EducationModel;

class EducationController extends ResourceController
{
    protected $modelName = 'App\Models\EducationModel';
    protected $format    = 'json';

    public function index()
    {
        helper('text');
        $search = $this->request->getGet('search');
        $filter = $this->request->getGet('filter'); // New Filter
        $sort = $this->request->getGet('sort') ?? 'id';
        $order = $this->request->getGet('order') ?? 'DESC';

        $model = new EducationModel();

        if ($search) {
            if (strlen($search) >= 3) {
                $model->groupStart()
                    ->like('institution', $search)
                    ->orLike('major', $search)
                ->groupEnd();
            } else {
                session()->setFlashdata('warning', 'Kata kunci pencarian minimal 3 karakter.');
            }
        }

        // Apply Filter
        if ($filter) {
            $model->where('level', $filter);
        }

        $data = [
            'educations' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'filter' => $filter, // Pass to view
            'sort' => $sort,
            'order' => $order,
            'title' => 'Daftar Riwayat Pendidikan'
        ];

        return view('admin/education/index', $data);
    }

    public function new()
    {
        return view('admin/education/form', ['title' => 'Tambah Pendidikan']);
    }

    public function create()
    {
        $rules = [
            'institution' => 'required',
            'level' => 'required',
            'start_year' => 'required|numeric',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = $this->request->getPost();
        
        $this->model->insert($data);
        return redirect()->to('/admin/education')->with('message', 'Pendidikan berhasil ditambahkan');
    }

    public function edit($id = null)
    {
        $data = [
            'education' => $this->model->find($id),
            'title' => 'Edit Pendidikan'
        ];
        return view('admin/education/form', $data);
    }

    public function update($id = null)
    {
        $rules = [
            'institution' => 'required',
            'level' => 'required',
            'start_year' => 'required|numeric',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $data = $this->request->getPost();

        $this->model->update($id, $data);
        return redirect()->to('/admin/education')->with('message', 'Pendidikan berhasil diperbarui');
    }

    public function delete($id = null)
    {
        $this->model->delete($id);
        return redirect()->to('/admin/education')->with('message', 'Pendidikan berhasil dihapus');
    }
}
