<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold"><?= $title ?></h3>
        <a href="<?= base_url('admin/certificate') ?>" class="flex items-center text-gray-600 hover:text-indigo-600 transition-colors">
            <i class="fas fa-arrow-left mr-2"></i> Kembali
        </a>
    </div>

    <div class="bg-white p-8 rounded-2xl shadow-lg border border-gray-100">
        <?php if(session()->getFlashdata('errors')): ?>
            <div class="bg-red-50 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-r">
                <div class="font-bold mb-2"><i class="fas fa-exclamation-circle mr-2"></i> Ada Kesalahan:</div>
                <ul class="list-disc list-inside text-sm">
                    <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?= isset($certificate) ? base_url('admin/certificate/' . $certificate['id'] . '/update') : base_url('admin/certificate/create') ?>" method="post" enctype="multipart/form-data">
            <?= csrf_field() ?>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Title -->
                <div class="mb-4 md:col-span-2">
                    <label for="title" class="block text-gray-700 font-bold mb-2">Nama Sertifikat</label>
                    <input type="text" name="title" id="title" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($certificate) ? esc($certificate['title']) : old('title') ?>" required placeholder="Contoh: Google Data Analytics">
                </div>

                <!-- Issuer -->
                <div class="mb-4">
                    <label for="issuer" class="block text-gray-700 font-bold mb-2">Penerbit</label>
                    <input type="text" name="issuer" id="issuer" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($certificate) ? esc($certificate['issuer']) : old('issuer') ?>" required placeholder="Contoh: Google">
                </div>

                <!-- Issue Date -->
                <div class="mb-4">
                    <label for="issue_date" class="block text-gray-700 font-bold mb-2">Tanggal Terbit</label>
                    <input type="date" name="issue_date" id="issue_date" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($certificate) ? esc($certificate['issue_date']) : old('issue_date') ?>">
                </div>

                <!-- Credential ID -->
                <div class="mb-4">
                    <label for="credential_id" class="block text-gray-700 font-bold mb-2">ID Kredensial (Opsional)</label>
                    <input type="text" name="credential_id" id="credential_id" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($certificate) ? esc($certificate['credential_id']) : old('credential_id') ?>" placeholder="Contoh: ABC123XYZ">
                </div>

                <!-- Credential URL -->
                <div class="mb-4">
                    <label for="credential_url" class="block text-gray-700 font-bold mb-2">Link Kredensial (Opsional)</label>
                    <input type="url" name="credential_url" id="credential_url" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($certificate) ? esc($certificate['credential_url']) : old('credential_url') ?>" placeholder="https://credential.example.com/...">
                </div>

                <!-- Description -->
                <div class="mb-4 md:col-span-2">
                    <label for="description" class="block text-gray-700 font-bold mb-2">Deskripsi (Opsional)</label>
                    <textarea name="description" id="description" rows="3" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" placeholder="Detail tentang sertifikat..."><?= isset($certificate) ? esc($certificate['description']) : old('description') ?></textarea>
                </div>

                <!-- Image -->
                <div class="mb-6 md:col-span-2">
                    <label for="image" class="block text-gray-700 font-bold mb-2">Gambar Sertifikat (Opsional)</label>
                    <div class="flex items-center space-x-4">
                        <?php if(isset($certificate) && $certificate['image']): ?>
                            <img src="<?= base_url($certificate['image']) ?>" class="h-24 w-32 object-cover rounded-xl border-2 border-gray-200 shadow-sm">
                        <?php endif; ?>
                        <div class="w-full">
                            <input type="file" name="image" id="image" accept="image/*" class="block w-full text-sm text-gray-500
                                file:mr-4 file:py-2 file:px-4
                                file:rounded-full file:border-0
                                file:text-sm file:font-semibold
                                file:bg-primary file:text-white
                                hover:file:bg-indigo-700
                                cursor-pointer
                            ">
                            <p class="text-xs text-gray-500 mt-1">Format: JPG, PNG, GIF. Maks: 2MB</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-6 flex justify-end">
                <button type="submit" class="bg-primary hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                    <i class="fas fa-save mr-2"></i> Simpan Sertifikat
                </button>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
