<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold">Daftar Sertifikat</h3>
        <a href="<?= base_url('admin/certificate/new') ?>" class="bg-primary hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-xl shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
            <i class="fas fa-plus mr-2"></i> Tambah Sertifikat
        </a>
    </div>

    <!-- Search -->
    <div class="mb-6 flex justify-between items-center bg-white p-4 rounded-xl shadow-sm border border-gray-100">
        <form action="" method="get" class="flex w-full sm:w-auto relative group items-center gap-2">
            <div class="relative flex-grow">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fas fa-search text-gray-400 group-focus-within:text-primary transition-colors"></i>
                </div>
                <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari sertifikat..." class="pl-10 pr-4 py-2 border border-gray-200 rounded-lg w-full sm:w-64 focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all">
            </div>
            <button type="submit" class="bg-gray-100 text-gray-600 px-4 py-2 rounded-lg hover:bg-gray-200 transition-colors font-medium">Cari</button>
        </form>
    </div>

    <?php if(session()->getFlashdata('message')): ?>
        <div class="bg-green-50 border-l-4 border-green-500 text-green-700 p-4 rounded-r shadow-sm mb-6 flex items-center" role="alert">
            <i class="fas fa-check-circle mr-3 text-lg"></i>
            <span class="font-medium"><?= session()->getFlashdata('message') ?></span>
        </div>
    <?php endif; ?>

    <div class="bg-white shadow-lg rounded-2xl overflow-hidden border border-gray-100">
        <table class="min-w-full leading-normal">
            <thead>
                <tr>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        Sertifikat
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        Penerbit
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-left text-xs font-bold text-gray-500 uppercase tracking-wider">
                        Tanggal
                    </th>
                    <th class="px-6 py-4 border-b border-gray-100 bg-gray-50 text-right text-xs font-bold text-gray-500 uppercase tracking-wider">
                        Aksi
                    </th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php if(!empty($certificates)): ?>
                    <?php foreach ($certificates as $cert): ?>
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <?php if($cert['image']): ?>
                                    <img src="<?= base_url($cert['image']) ?>" class="w-12 h-12 object-cover rounded-lg mr-4">
                                <?php else: ?>
                                    <div class="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mr-4">
                                        <i class="fas fa-certificate text-primary text-xl"></i>
                                    </div>
                                <?php endif; ?>
                                <div>
                                    <p class="text-gray-900 font-bold"><?= esc($cert['title']) ?></p>
                                    <?php if($cert['credential_id']): ?>
                                        <p class="text-gray-500 text-xs mt-0.5">ID: <?= esc($cert['credential_id']) ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-gray-600"><?= esc($cert['issuer']) ?></span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-gray-600 text-sm"><?= $cert['issue_date'] ? date('d M Y', strtotime($cert['issue_date'])) : '-' ?></span>
                        </td>
                        <td class="px-6 py-4 text-right">
                            <div class="flex items-center justify-end space-x-3">
                                <a href="<?= base_url('admin/certificate/' . $cert['id'] . '/edit') ?>" class="text-yellow-500 hover:text-yellow-600 bg-yellow-50 hover:bg-yellow-100 p-2 rounded-lg transition-all" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <button onclick="confirmDelete(<?= $cert['id'] ?>, '<?= base_url('admin/certificate/' . $cert['id'] . '/delete') ?>')" class="text-red-500 hover:text-red-600 bg-red-50 hover:bg-red-100 p-2 rounded-lg transition-all" title="Hapus">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" class="px-6 py-12 text-center text-gray-400">
                            <i class="fas fa-certificate text-4xl mb-4"></i>
                            <p>Belum ada sertifikat.</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="px-6 py-4 bg-gray-50 border-t border-gray-100">
             <?= $pager->links() ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
