<?= $this->extend('layouts/frontend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-12">
    
    <!-- Header -->
    <div class="flex justify-between items-end mb-12 page-transition">
        <div>
            <h2 class="text-4xl font-bold mb-2">Aktivitas Harian</h2>
            <p class="text-gray-400">Galeri kehidupan sehari-hari dan pekerjaan saya.</p>
        </div>
        <form action="" method="get" class="w-full md:w-auto flex flex-col md:flex-row gap-3">
            <!-- Filter -->
            <select name="filter" onchange="this.form.submit()" class="bg-gray-800 border border-gray-700 text-white px-4 py-2 rounded-lg focus:outline-none focus:border-primary">
                <option value="">Semua Tipe</option>
                <option value="photo" <?= $filter == 'photo' ? 'selected' : '' ?>>Foto</option>
                <option value="video" <?= $filter == 'video' ? 'selected' : '' ?>>Video</option>
            </select>

            <!-- Sort -->
            <select name="order" onchange="this.form.submit()" class="bg-gray-800 border border-gray-700 text-white px-4 py-2 rounded-lg focus:outline-none focus:border-primary">
                <option value="DESC" <?= $order == 'DESC' ? 'selected' : '' ?>>Terbaru</option>
                <option value="ASC" <?= $order == 'ASC' ? 'selected' : '' ?>>Terlama</option>
            </select>

            <!-- Search -->
            <div class="relative">
                <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari Aktivitas..." class="bg-gray-800 border border-gray-700 text-white pl-4 pr-10 py-2 rounded-lg focus:outline-none focus:border-primary w-full md:w-64">
                <button type="submit" class="absolute right-3 top-2 text-gray-400 hover:text-white">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>

    <!-- Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        <?php foreach($activities as $index => $activity): ?>
            <div class="group relative bg-gray-800 rounded-xl overflow-hidden shadow-2xl hover:shadow-primary/50 transition-all duration-300 transform hover:-translate-y-2 page-transition" style="animation-delay: <?= $index * 100 ?>ms;">
                
                <!-- Date Badge -->
                <div class="absolute top-4 left-4 z-20 bg-gray-900 bg-opacity-80 backdrop-blur text-white px-3 py-1 rounded-full text-xs font-bold border border-gray-700">
                    <?= date('d M Y', strtotime($activity['date'])) ?>
                </div>

                <!-- Media -->
                <?php if($activity['media_path']): ?>
                    <div class="relative h-64 overflow-hidden">
                        <?php if($activity['media_type'] == 'photo'): ?>
                            <img src="<?= base_url($activity['media_path']) ?>" class="w-full h-full object-cover transition duration-700 group-hover:scale-110">
                        <?php elseif($activity['media_type'] == 'video'): ?>
                            <video src="<?= base_url($activity['media_path']) ?>" class="w-full h-full object-cover" controls></video>
                        <?php endif; ?>
                        <!-- Overlay -->
                        <div class="absolute inset-0 bg-gradient-to-t from-gray-900 to-transparent opacity-60"></div>
                    </div>
                <?php else: ?>
                    <div class="h-48 bg-gray-700 flex items-center justify-center relative overflow-hidden group-hover:bg-gray-600 transition">
                         <i class="fas fa-clock text-6xl text-gray-800 absolute transform -rotate-12 group-hover:rotate-0 transition duration-500"></i>
                    </div>
                <?php endif; ?>

                <!-- Content -->
                <div class="p-6 relative z-10 w-full <?= $activity['media_path'] ? '-mt-12' : '' ?>">
                    <h3 class="text-xl font-bold text-white mb-2 leading-tight"><?= esc($activity['activity_name']) ?></h3>
                    <div class="flex items-center text-sm text-gray-400 mb-4">
                        <i class="far fa-clock mr-2"></i> <?= esc($activity['time']) ?>
                    </div>
                    <p class="text-gray-300 text-sm line-clamp-3 group-hover:line-clamp-none transition-all duration-300">
                        <?= esc($activity['description']) ?>
                    </p>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
    
    <?php if(empty($activities)): ?>
        <p class="text-center text-gray-500 py-12 page-transition">Tidak ada aktivitas ditemukan.</p>
    <?php endif; ?>

    <div class="mt-12 page-transition">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection() ?>
