<?= $this->extend('layouts/frontend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-4 sm:px-6 py-8 md:py-16 flex flex-col md:flex-row items-center relative overflow-hidden min-h-[80vh]">
    
    <!-- Hero Text -->
    <div class="w-full md:w-1/2 text-center md:text-left z-10 page-transition">
        <div class="inline-block px-4 py-2 bg-primary/10 rounded-full text-primary text-sm font-medium mb-6 animate-pulse">
            <i class="fas fa-star mr-2"></i>Selamat Datang di Portfolio Saya
        </div>
        <h1 class="text-4xl sm:text-5xl md:text-7xl font-bold leading-tight mb-6">
            Pengembang <br class="hidden sm:block">
            <span class="gradient-animated-text" id="typed-text">Kreatif_</span>
        </h1>
        <p class="text-lg sm:text-xl text-gray-300 mb-8 max-w-lg mx-auto md:mx-0 leading-relaxed">
            Membangun pengalaman digital yang menginspirasi dan menarik.
            Portofolio lengkap aktivitas harian, riwayat pendidikan, dan bio profesional saya.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center md:justify-start">
            <a href="<?= base_url('profile') ?>" class="group px-8 py-4 bg-gradient-to-r from-primary to-indigo-600 text-white font-bold rounded-full hover:shadow-lg hover:shadow-primary/50 transition-all duration-300 transform hover:-translate-y-1 flex items-center justify-center gap-2">
                <i class="fas fa-user group-hover:rotate-12 transition-transform"></i>
                Lihat Profil
            </a>
            <a href="<?= base_url('activities') ?>" class="group px-8 py-4 border-2 border-white/30 text-white font-bold rounded-full hover:bg-white hover:text-gray-900 transition-all duration-300 transform hover:-translate-y-1 backdrop-blur-sm flex items-center justify-center gap-2">
                <i class="fas fa-camera group-hover:scale-110 transition-transform"></i>
                Aktivitas Terbaru
            </a>
        </div>
        
        <!-- Social Stats -->
        <div class="flex flex-wrap gap-6 mt-10 justify-center md:justify-start">
            <div class="text-center">
                <div class="text-3xl font-bold text-white counter" data-target="100">0</div>
                <div class="text-gray-400 text-sm">Proyek</div>
            </div>
            <div class="w-px h-12 bg-gray-700 hidden sm:block"></div>
            <div class="text-center">
                <div class="text-3xl font-bold text-white counter" data-target="50">0</div>
                <div class="text-gray-400 text-sm">Aktivitas</div>
            </div>
            <div class="w-px h-12 bg-gray-700 hidden sm:block"></div>
            <div class="text-center">
                <div class="text-3xl font-bold text-white counter" data-target="5">0</div>
                <div class="text-gray-400 text-sm">Tahun Pengalaman</div>
            </div>
        </div>
    </div>

    <!-- Hero Visual -->
    <div class="w-full md:w-1/2 mt-12 md:mt-0 relative page-transition" style="animation-delay: 200ms;">
        <!-- Animated Blob/Shape -->
        <div class="absolute top-0 right-0 w-64 sm:w-96 h-64 sm:h-96 bg-secondary opacity-20 rounded-full mix-blend-multiply filter blur-3xl animate-blob"></div>
        <div class="absolute top-0 right-10 sm:right-20 w-64 sm:w-96 h-64 sm:h-96 bg-primary opacity-20 rounded-full mix-blend-multiply filter blur-3xl animate-blob animation-delay-2000"></div>
        
        <div class="relative z-10 bg-gray-800/60 p-4 sm:p-6 rounded-2xl backdrop-blur-xl border border-gray-700/50 shadow-2xl transform rotate-0 sm:rotate-3 hover:rotate-0 transition-all duration-500 hover:shadow-primary/20 mx-4 sm:mx-0">
            <!-- Terminal Header -->
            <div class="flex items-center space-x-2 sm:space-x-4 mb-4">
                <div class="flex space-x-2">
                    <div class="w-3 h-3 bg-red-500 rounded-full hover:scale-125 transition-transform cursor-pointer"></div>
                    <div class="w-3 h-3 bg-yellow-500 rounded-full hover:scale-125 transition-transform cursor-pointer"></div>
                    <div class="w-3 h-3 bg-green-500 rounded-full hover:scale-125 transition-transform cursor-pointer"></div>
                </div>
                <div class="flex-1 text-center text-xs text-gray-500 font-mono">developer.js</div>
            </div>
            <!-- Terminal Content -->
            <div class="space-y-2 font-mono text-xs sm:text-sm text-gray-300">
                <p><span class="text-pink-500">const</span> <span class="text-blue-400">developer</span> = {</p>
                <p class="pl-4"><span class="text-gray-500">name:</span> <span class="text-green-400">'Muhamad Abdul Aziz'</span>,</p>
                <p class="pl-4"><span class="text-gray-500">role:</span> <span class="text-green-400">'Full Stack Developer'</span>,</p>
                <p class="pl-4"><span class="text-gray-500">skills:</span> [<span class="text-green-400">'CI4'</span>, <span class="text-green-400">'Tailwind'</span>, <span class="text-green-400">'Anime.js'</span>],</p>
                <p class="pl-4"><span class="text-gray-500">available:</span> <span class="text-yellow-400">true</span></p>
                <p>};</p>
                <p class="text-gray-500 mt-4">// Siap membangun sesuatu yang luar biasa <span class="animate-pulse">▎</span></p>
            </div>
        </div>
        
        <!-- Floating Badge -->
        <div class="absolute -bottom-4 -right-2 sm:-right-4 bg-gradient-to-r from-green-400 to-emerald-500 text-white px-4 py-2 rounded-full text-sm font-bold shadow-lg animate-bounce z-20">
            <i class="fas fa-check-circle mr-2"></i>Siap Bekerja
        </div>
    </div>
</div>

<style>
    @keyframes blob {
        0% { transform: translate(0px, 0px) scale(1); }
        33% { transform: translate(30px, -50px) scale(1.1); }
        66% { transform: translate(-20px, 20px) scale(0.9); }
        100% { transform: translate(0px, 0px) scale(1); }
    }
    .animate-blob {
        animation: blob 7s infinite;
    }
    .animation-delay-2000 {
        animation-delay: 2s;
    }
    
    /* Gradient Animated Text */
    .gradient-animated-text {
        background: linear-gradient(90deg, #4F46E5, #EC4899, #8B5CF6, #4F46E5);
        background-size: 300% 300%;
        -webkit-background-clip: text;
        background-clip: text;
        color: transparent;
        animation: gradient-shift 4s ease infinite;
    }
    
    @keyframes gradient-shift {
        0% { background-position: 0% 50%; }
        50% { background-position: 100% 50%; }
        100% { background-position: 0% 50%; }
    }
    
    /* Typing Effect */
    @keyframes blink {
        0%, 100% { opacity: 1; }
        50% { opacity: 0; }
    }
</style>

<script>
    // Typing Effect
    const words = ['Kreatif', 'Inovatif', 'Profesional', 'Berpengalaman'];
    let wordIndex = 0;
    let charIndex = 0;
    let isDeleting = false;
    const typedText = document.getElementById('typed-text');
    
    function type() {
        const currentWord = words[wordIndex];
        
        if (isDeleting) {
            typedText.textContent = currentWord.substring(0, charIndex - 1) + '_';
            charIndex--;
        } else {
            typedText.textContent = currentWord.substring(0, charIndex + 1) + '_';
            charIndex++;
        }
        
        if (!isDeleting && charIndex === currentWord.length) {
            setTimeout(() => isDeleting = true, 2000);
        } else if (isDeleting && charIndex === 0) {
            isDeleting = false;
            wordIndex = (wordIndex + 1) % words.length;
        }
        
        const speed = isDeleting ? 50 : 100;
        setTimeout(type, speed);
    }
    
    // Counter Animation
    const counters = document.querySelectorAll('.counter');
    counters.forEach(counter => {
        const target = +counter.getAttribute('data-target');
        const increment = target / 50;
        
        function updateCounter() {
            const current = +counter.innerText;
            if (current < target) {
                counter.innerText = Math.ceil(current + increment);
                setTimeout(updateCounter, 30);
            } else {
                counter.innerText = target + '+';
            }
        }
        
        // Start counter when element is visible
        const observer = new IntersectionObserver(entries => {
            if (entries[0].isIntersecting) {
                updateCounter();
                observer.disconnect();
            }
        });
        observer.observe(counter);
    });
    
    // Start typing when page loads
    setTimeout(type, 1000);
</script>

<?= $this->endSection() ?>

