<?= $this->extend('layouts/frontend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-12">
    
    <!-- Search Header -->
    <div class="flex justify-between items-end mb-10 page-transition">
        <div>
            <h2 class="text-4xl font-bold mb-2">Profil Saya</h2>
            <p class="text-gray-400">Detail pribadi dan ringkasan profesional.</p>
        </div>
        <form action="" method="get" class="relative">
            <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari Biografi..." class="bg-gray-800 border border-gray-700 text-white px-4 py-2 rounded-full focus:outline-none focus:border-primary w-64">
            <button type="submit" class="absolute right-3 top-2 text-gray-400 hover:text-white">
                <i class="fas fa-search"></i>
            </button>
        </form>
    </div>

    <?php if(empty($profiles)): ?>
        <p class="text-gray-500 page-transition">Data profil tidak ditemukan.</p>
    <?php endif; ?>

    <div class="grid grid-cols-1 gap-12">
        <?php foreach($profiles as $index => $profile): ?>
            <div class="bg-gray-800 rounded-2xl p-8 flex flex-col md:flex-row shadow-2xl hover:shadow-primary/20 transition duration-500 page-transition" style="animation-delay: <?= $index * 100 ?>ms;">
                
                <!-- Photo -->
                <div class="md:w-1/3 flex justify-center md:justify-start mb-6 md:mb-0">
                    <div class="relative w-48 h-48 md:w-64 md:h-64">
                        <div class="absolute inset-0 bg-gradient-to-tr from-primary to-secondary rounded-full blur-lg opacity-75 animate-pulse"></div>
                        <?php if($profile['photo']): ?>
                            <img src="<?= base_url($profile['photo']) ?>" alt="<?= esc($profile['full_name']) ?>" class="relative w-full h-full object-cover rounded-full border-4 border-gray-900 z-10">
                        <?php else: ?>
                            <div class="relative w-full h-full bg-gray-700 rounded-full flex items-center justify-center border-4 border-gray-900 z-10">
                                <i class="fas fa-user text-6xl text-gray-500"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Content -->
                <div class="md:w-2/3 md:pl-12 flex flex-col justify-center">
                    <h3 class="text-3xl font-bold mb-2 text-white"><?= esc($profile['full_name']) ?></h3>
                    <div class="flex items-center space-x-4 text-gray-400 mb-6 font-mono text-sm">
                        <span><i class="fas fa-envelope mr-2"></i><?= esc($profile['email']) ?></span>
                        <?php if($profile['phone']): ?>
                            <span><i class="fas fa-phone mr-2"></i><?= esc($profile['phone']) ?></span>
                        <?php endif; ?>
                    </div>
                    
                    <div class="bg-gray-900/50 p-6 rounded-xl border border-gray-700 backdrop-blur-sm">
                        <h4 class="text-primary font-bold mb-3 uppercase tracking-wider text-sm">Biografi</h4>
                        <p class="text-gray-300 leading-relaxed"><?= nl2br(esc($profile['bio'])) ?></p>
                    </div>

                    <div class="mt-6 text-gray-500 text-sm">
                        <i class="fas fa-map-marker-alt mr-2"></i> <?= esc($profile['address']) ?>
                    </div>
                </div>

            </div>
        <?php endforeach; ?>
    </div>

    <!-- Certificates Section -->
    <?php if(!empty($certificates)): ?>
    <div class="mt-16 page-transition">
        <div class="flex items-center mb-8">
            <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-500 rounded-xl flex items-center justify-center mr-4 shadow-lg shadow-purple-500/30">
                <i class="fas fa-certificate text-white text-xl"></i>
            </div>
            <div>
                <h3 class="text-2xl font-bold text-white">Sertifikat & Pencapaian</h3>
                <p class="text-gray-400 text-sm">Kredensial dan sertifikasi profesional</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach($certificates as $index => $cert): ?>
            <div class="bg-gray-800 rounded-2xl overflow-hidden shadow-xl hover:shadow-primary/20 transition-all duration-500 hover:-translate-y-2 group page-transition" style="animation-delay: <?= ($index + 1) * 100 ?>ms;">
                <!-- Certificate Image -->
                <?php if($cert['image']): ?>
                <div class="h-40 overflow-hidden">
                    <img src="<?= base_url($cert['image']) ?>" alt="<?= esc($cert['title']) ?>" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                </div>
                <?php else: ?>
                <div class="h-40 bg-gradient-to-br from-purple-500/20 to-pink-500/20 flex items-center justify-center">
                    <i class="fas fa-certificate text-purple-400 text-5xl opacity-50"></i>
                </div>
                <?php endif; ?>
                
                <!-- Content -->
                <div class="p-6">
                    <h4 class="font-bold text-white text-lg mb-2 group-hover:text-primary transition-colors"><?= esc($cert['title']) ?></h4>
                    <p class="text-primary text-sm font-medium mb-3">
                        <i class="fas fa-building mr-2"></i><?= esc($cert['issuer']) ?>
                    </p>
                    
                    <?php if($cert['issue_date']): ?>
                    <p class="text-gray-400 text-xs mb-3">
                        <i class="fas fa-calendar mr-2"></i><?= date('d M Y', strtotime($cert['issue_date'])) ?>
                    </p>
                    <?php endif; ?>
                    
                    <?php if($cert['credential_id']): ?>
                    <p class="text-gray-500 text-xs font-mono bg-gray-900 px-3 py-1.5 rounded-lg inline-block">
                        ID: <?= esc($cert['credential_id']) ?>
                    </p>
                    <?php endif; ?>
                    
                    <?php if($cert['credential_url']): ?>
                    <div class="mt-4">
                        <a href="<?= esc($cert['credential_url']) ?>" target="_blank" class="text-primary hover:text-white text-sm font-medium hover:underline">
                            <i class="fas fa-external-link-alt mr-2"></i>Lihat Kredensial
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- Pager -->
    <div class="mt-12 page-transition">
        <?= $pager->links() ?>
    </div>
</div>

<?= $this->endSection() ?>
