<?php

// Load CI4
require_once 'vendor/autoload.php';

// Boot the app
$app = \Config\Services::codeigniter();
$app->initialize();

$db = \Config\Database::connect();

echo "=== Current Education Data ===\n";
$educations = $db->table('educations')->get()->getResultArray();
foreach ($educations as $edu) {
    echo "ID: {$edu['id']}, Institution: {$edu['institution']}, Level: '{$edu['level']}'\n";
}

echo "\n=== Fixing Data ===\n";
// Update education with empty or wrong level
$db->table('educations')->where('level', '')->orWhere('level', 'Bachelor')->orWhere('level', 'Bachelor (S1)')->update(['level' => 'Sarjana (S1)']);
$db->table('educations')->where('level', 'Master')->orWhere('level', 'Master (S2)')->update(['level' => 'Magister (S2)']);
$db->table('educations')->where('level', 'Doctoral')->orWhere('level', 'Doctoral (S3)')->update(['level' => 'Doktor (S3)']);
$db->table('educations')->where('level', 'SMA')->update(['level' => 'SMA/SMK']);

echo "Data updated!\n";

echo "\n=== Updated Education Data ===\n";
$educations = $db->table('educations')->get()->getResultArray();
foreach ($educations as $edu) {
    echo "ID: {$edu['id']}, Institution: {$edu['institution']}, Level: '{$edu['level']}'\n";
}
