<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Activities</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/activities/new" class="btn btn-sm btn-outline-primary">Add New Activity</a>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-light">
        <h6 class="mb-0">Filter Activities</h6>
    </div>
    <div class="card-body">
        <form method="get">
            <div class="row g-3">
                <div class="col-md-4">
                    <label class="form-label small">Search</label>
                    <input type="text" name="search" class="form-control" placeholder="Search activities..."
                        value="<?= esc($search) ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label small">Date</label>
                    <input type="date" name="date" class="form-control" value="<?= esc($date ?? '') ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label small">Type</label>
                    <select name="type" class="form-select">
                        <option value="all" <?= (empty($type) || $type == 'all') ? 'selected' : '' ?>>All Types</option>
                        <option value="with_media" <?= ($type == 'with_media') ? 'selected' : '' ?>>With Media</option>
                        <option value="no_media" <?= ($type == 'no_media') ? 'selected' : '' ?>>Text Only</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label small">Sort By</label>
                    <select name="sort" class="form-select">
                        <option value="newest" <?= ($sort == 'newest') ? 'selected' : '' ?>>Newest</option>
                        <option value="oldest" <?= ($sort == 'oldest') ? 'selected' : '' ?>>Oldest</option>
                    </select>
                </div>
                <div class="col-12 text-end">
                    <button class="btn btn-primary" type="submit">Apply Filter</button>
                    <a href="/admin/activities" class="btn btn-outline-secondary">Reset</a>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="table-responsive">
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>
                    <a
                        href="?sort=date&order=<?= $order === 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&date=<?= esc($date) ?>&type=<?= esc($type) ?>">
                        Date <?= $sort === 'date' ? ($order === 'ASC' ? '▲' : '▼') : '' ?>
                    </a>
                </th>
                <th>
                    <a
                        href="?sort=time&order=<?= $order === 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&date=<?= esc($date) ?>&type=<?= esc($type) ?>">
                        Time <?= $sort === 'time' ? ($order === 'ASC' ? '▲' : '▼') : '' ?>
                    </a>
                </th>
                <th>
                    <a
                        href="?sort=activity&order=<?= $order === 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&date=<?= esc($date) ?>&type=<?= esc($type) ?>">
                        Activity <?= $sort === 'activity' ? ($order === 'ASC' ? '▲' : '▼') : '' ?>
                    </a>
                </th>
                <th>Media</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($activities): ?>
                <?php foreach ($activities as $activity): ?>
                    <tr>
                        <td><?= $activity['date'] ?></td>
                        <td><?= $activity['time'] ?></td>
                        <td><?= $activity['activity'] ?></td>
                        <td>
                            <?php if ($activity['media']): ?>
                                <img src="/uploads/<?= $activity['media'] ?>" height="50">
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="/admin/activities/edit/<?= $activity['id'] ?>" class="btn btn-sm btn-secondary">Edit</a>
                            <a href="/admin/activities/delete/<?= $activity['id'] ?>" class="btn btn-sm btn-danger"
                                onclick="return confirm('Are you sure?')">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5">No activities found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?= $pager->links() ?>
</div>
<?= $this->endSection() ?>