<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Education</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/education/new" class="btn btn-sm btn-outline-primary">Add New Education</a>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header bg-light">
        <h6 class="mb-0">Filter Education</h6>
    </div>
    <div class="card-body">
        <form method="get">
            <div class="row g-3">
                <div class="col-md-5">
                    <label class="form-label small">Search</label>
                    <input type="text" name="search" class="form-control" placeholder="Search institution..."
                        value="<?= esc($search) ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label small">Start Year</label>
                    <input type="number" name="start_year" class="form-control" placeholder="YYYY"
                        value="<?= esc($start_year ?? '') ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label small">Sort By</label>
                    <select name="sort" class="form-select">
                        <option value="newest" <?= ($sort == 'newest') ? 'selected' : '' ?>>Newest</option>
                        <option value="oldest" <?= ($sort == 'oldest') ? 'selected' : '' ?>>Oldest</option>
                    </select>
                </div>
                <div class="col-12 text-end">
                    <button class="btn btn-primary" type="submit">Apply Filter</button>
                    <a href="/admin/education" class="btn btn-outline-secondary">Reset</a>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="table-responsive">
    <table class="table table-striped table-sm">
        <thead>
            <tr>
                <th>
                    <a
                        href="?sort=institution&order=<?= $order === 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&start_year=<?= esc($start_year) ?>">
                        Institution <?= $sort === 'institution' ? ($order === 'ASC' ? '▲' : '▼') : '' ?>
                    </a>
                </th>
                <th>
                    <a
                        href="?sort=start_year&order=<?= $order === 'ASC' ? 'DESC' : 'ASC' ?>&search=<?= esc($search) ?>&start_year=<?= esc($start_year) ?>">
                        Period (Year) <?= $sort === 'start_year' ? ($order === 'ASC' ? '▲' : '▼') : '' ?>
                    </a>
                </th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($education): ?>
                <?php foreach ($education as $item): ?>
                    <tr>
                        <td><?= $item['institution'] ?></td>
                        <td><?= $item['start_year'] ?> - <?= $item['end_year'] ?? 'Present' ?></td>
                        <td><?= $item['description'] ?></td>
                        <td>
                            <a href="/admin/education/edit/<?= $item['id'] ?>" class="btn btn-sm btn-secondary">Edit</a>
                            <a href="/admin/education/delete/<?= $item['id'] ?>" class="btn btn-sm btn-danger"
                                onclick="return confirm('Are you sure?')">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4">No education records found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <?= $pager->links() ?>
</div>
<?= $this->endSection() ?>