<?= $this->extend('public/layout/template') ?>

<?= $this->section('content') ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Profile Card -->
            <div class="profile-header-card animate-fade-in-up">
                <!-- Cover Image -->
                <div class="profile-cover"></div>

                <div class="card-body px-4 px-md-5 pb-5">
                    <!-- Profile Image -->
                    <div class="profile-img-container">
                        <img src="/images/profile.jpg" alt="Diki Satria" class="profile-img">
                    </div>

                    <!-- Header Text -->
                    <div class="text-center mb-5">
                        <h1 class="fw-bold mb-2 text-dark">Diki Satria</h1>
                        <p class="text-secondary fs-5 mb-3">Web Developer & Designer</p>
                        <div class="d-flex justify-content-center gap-2">
                            <!-- Example Social/Action Buttons -->
                            <a href="mailto:contact@diki.com" class="btn btn-primary rounded-pill px-4 shadow-sm">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor" class="me-2">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                                Hubungi Saya
                            </a>
                            <a href="/education" class="btn btn-outline-primary rounded-pill px-4">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="none"
                                    viewBox="0 0 24 24" stroke="currentColor" class="me-2">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 14l9-5-9-5-9 5 9 5z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 14l6.16-3.422a12.083 12.083 0 01.665 6.479A11.952 11.952 0 0012 20.055a11.952 11.952 0 00-6.824-2.998 12.078 12.078 0 01.665-6.479L12 14z" />
                                </svg>
                                Pendidikan
                            </a>
                        </div>
                    </div>

                    <div class="row g-5">
                        <!-- Left Column: About & Skills -->
                        <div class="col-lg-7 animate-fade-in-up delay-100">
                            <div class="mb-5">
                                <h4 class="fw-bold text-dark mb-3 d-flex align-items-center">
                                    <span class="bg-primary bg-opacity-10 text-primary p-2 rounded-circle me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                        </svg>
                                    </span>
                                    Tentang Saya
                                </h4>
                                <div class="bg-light p-4 rounded-4 text-secondary" style="line-height: 1.8;">
                                    <?php
                                    $hasAbout = false;
                                    foreach ($biodata as $b) {
                                        if (stripos($b['field_key'], 'Tentang') !== false) {
                                            echo nl2br(esc($b['field_value']));
                                            $hasAbout = true;
                                            break;
                                        }
                                    }
                                    if (!$hasAbout)
                                        echo "Saya adalah seorang profesional yang berdedikasi tinggi untuk terus belajar dan berkembang di dunia teknologi.";
                                    ?>
                                </div>
                            </div>

                            <div>
                                <h4 class="fw-bold text-dark mb-3 d-flex align-items-center">
                                    <span class="bg-primary bg-opacity-10 text-primary p-2 rounded-circle me-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none"
                                            viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M13 10V3L4 14h7v7l9-11h-7z" />
                                        </svg>
                                    </span>
                                    Keahlian & Skill
                                </h4>
                                <div class="d-flex flex-wrap gap-2">
                                    <?php
                                    foreach ($biodata as $item) {
                                        if (stripos($item['field_key'], 'Keahlian') !== false || stripos($item['field_key'], 'Skill') !== false) {
                                            $skills = explode("\n", $item['field_value']);
                                            foreach ($skills as $skill) {
                                                if (trim($skill)) {
                                                    echo '<span class="badge bg-white text-primary border border-2 px-3 py-2 rounded-pill skill-badge fs-6 fw-medium">' . esc(trim($skill)) . '</span>';
                                                }
                                            }
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>

                        <!-- Right Column: Personal Info -->
                        <div class="col-lg-5 animate-fade-in-up delay-200">
                            <div class="bg-white border rounded-4 p-4 h-100">
                                <h4 class="fw-bold text-dark mb-4 border-bottom pb-3">Informasi Pribadi</h4>
                                <div class="d-flex flex-column gap-3">
                                    <?php foreach ($biodata as $item): ?>
                                        <?php if (stripos($item['field_key'], 'Tentang') !== false || stripos($item['field_key'], 'Keahlian') !== false || stripos($item['field_key'], 'Skill') !== false)
                                            continue; ?>

                                        <div class="d-flex align-items-center p-3 rounded-3 info-item">
                                            <div
                                                class="flex-shrink-0 text-primary bg-primary bg-opacity-10 p-2 rounded-circle me-3">
                                                <!-- Icon Selection -->
                                                <?php if (stripos($item['field_key'], 'Email') !== false): ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none"
                                                        viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                                    </svg>
                                                <?php elseif (stripos($item['field_key'], 'Telepon') !== false || stripos($item['field_key'], 'HP') !== false): ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none"
                                                        viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                                    </svg>
                                                <?php elseif (stripos($item['field_key'], 'Alamat') !== false || stripos($item['field_key'], 'Lokasi') !== false): ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none"
                                                        viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                <?php else: ?>
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none"
                                                        viewBox="0 0 24 24" stroke="currentColor">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                            d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                                    </svg>
                                                <?php endif; ?>
                                            </div>
                                            <div class="overflow-hidden">
                                                <small class="text-uppercase text-muted fw-bold d-block mb-1"
                                                    style="font-size: 0.7rem; letter-spacing: 0.5px;"><?= esc($item['field_key']) ?></small>
                                                <span
                                                    class="text-dark fw-medium text-break"><?= esc($item['field_value']) ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>