<?= $this->extend('public/layout/template') ?>

<?= $this->section('content') ?>
<div class="container py-5">
    <div class="text-center mb-5">
        <h1 class="fw-bold display-5 text-dark">Riwayat Pendidikan</h1>
        <p class="text-muted lead">Perjalanan akademik dan pencapaian saya.</p>
    </div>

    <!-- Filter Component -->
    <div class="row justify-content-center mb-5">
        <div class="col-lg-8">
            <div class="card bg-white border-0 shadow-sm p-4 rounded-4">
                <div class="row align-items-center mb-3">
                    <div class="col-md-8">
                        <h5 class="fw-bold mb-1 text-primary">Kurasi cepat</h5>
                        <p class="text-muted small mb-0">Tapis riwayat pendidikan Anda.</p>
                    </div>
                    <div class="col-md-4 text-md-end">
                        <span class="badge bg-primary bg-opacity-10 py-2 px-3 rounded-pill text-primary">
                            <i class="bi bi-compass me-1"></i> Dinamis & siap disaring
                        </span>
                    </div>
                </div>

                <form action="" method="get">
                    <div class="row g-3">
                        <div class="col-md-5">
                            <label class="form-label small text-muted fw-semibold">Cari</label>
                            <input type="text" name="search" class="form-control bg-light border-0 text-dark"
                                placeholder="Nama Institusi..." value="<?= esc($search) ?>">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label small text-muted fw-semibold">Tahun Mulai</label>
                            <input type="number" name="start_year" class="form-control bg-light border-0 text-dark"
                                placeholder="YYYY" value="<?= esc($start_year ?? '') ?>">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label small text-muted fw-semibold">Urutkan</label>
                            <select name="sort" class="form-select bg-light border-0 text-dark">
                                <option value="newest" <?= ($sort == 'newest') ? 'selected' : '' ?>>Terbaru</option>
                                <option value="oldest" <?= ($sort == 'oldest') ? 'selected' : '' ?>>Terlama</option>
                            </select>
                        </div>
                        <div class="col-12 mt-3">
                            <button type="submit" class="btn btn-primary fw-bold w-100 text-white shadow-sm">
                                Terapkan filter
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Timeline Style Layout -->
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="position-relative">
                <!-- Vertical Line -->
                <div class="position-absolute start-0 h-100 border-start border-2 ms-4 d-none d-md-block"
                    style="border-color: #e5e7eb!important;"></div>

                <?php if ($education): ?>
                    <?php foreach ($education as $item): ?>
                        <div class="position-relative ps-md-5 mb-5">
                            <!-- Dot -->
                            <div class="position-absolute start-0 top-0 bg-white border border-4 border-primary rounded-circle d-none d-md-block"
                                style="width: 20px; height: 20px; margin-left: 1.3rem; margin-top: 5px; z-index: 1;"></div>

                            <div class="custom-card p-4 border-0 hover-lift">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <h4 class="fw-bold text-dark mb-0"><?= esc($item['institution']) ?></h4>
                                    <span class="badge bg-primary bg-opacity-10 text-primary px-3 py-2 rounded-pill">
                                        <?= $item['start_year'] ?> - <?= $item['end_year'] ?? 'Sekarang' ?>
                                    </span>
                                </div>
                                <p class="text-muted mb-0" style="line-height: 1.6;"><?= nl2br(esc($item['description'])) ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="alert alert-light text-center shadow-sm">Tidak ada riwayat pendidikan ditemukan.</div>
                <?php endif; ?>
            </div>

            <div class="d-flex justify-content-center mt-5">
                <?= $pager->links() ?>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>