# Panduan Deployment ke Rumah Web
## Subdomain: it.madaniyatsicreative.web.id

Panduan lengkap untuk mendeploy aplikasi Portal Berita CodeIgniter 4 ke hosting Rumah Web dengan subdomain `it.madaniyatsicreative.web.id`.

---

## 📋 Prerequisites

Sebelum memulai, pastikan Anda memiliki:
- ✅ Akun hosting Rumah Web yang aktif
- ✅ Akses cPanel atau File Manager
- ✅ Akses ke MySQL Database
- ✅ File aplikasi yang sudah siap (dari local development)

---

## 🗂 Struktur Folder di Rumah Web

Di Rumah Web, struktur folder biasanya seperti ini:

```
/home/username/
├── public_html/              → Folder utama untuk domain utama
├── it.madaniyatsicreative.web.id/  → Folder untuk subdomain
│   └── public_html/          → Folder public untuk subdomain
└── ...
```

**PENTING:** Untuk subdomain, file aplikasi harus diletakkan di:
- **Folder subdomain:** `/home/username/it.madaniyatsicreative.web.id/`
- **Public folder:** `/home/username/it.madaniyatsicreative.web.id/public_html/`

---

## 📝 Langkah-langkah Deployment

### 1. Setup Subdomain di cPanel

1. Login ke **cPanel** Rumah Web
2. Cari menu **"Subdomains"** atau **"Subdomain"**
3. Klik **"Create a Subdomain"**
4. Isi form:
   - **Subdomain:** `it`
   - **Domain:** `madaniyatsicreative.web.id`
   - **Document Root:** `/home/username/it.madaniyatsicreative.web.id/public_html`
5. Klik **"Create"**
6. Tunggu beberapa menit hingga subdomain aktif

**Catatan:** Jika subdomain sudah ada, lewati langkah ini.

---

### 2. Upload File Aplikasi

#### Opsi A: Menggunakan File Manager (cPanel)

1. Login ke cPanel
2. Buka **File Manager**
3. Navigasi ke folder: `/home/username/it.madaniyatsicreative.web.id/`
4. **Hapus file default** jika ada (index.html, dll)
5. Upload file aplikasi dengan struktur berikut:

```
it.madaniyatsicreative.web.id/
├── app/
├── public/
│   ├── index.php
│   ├── css/
│   ├── js/
│   ├── media/
│   └── uploads/
├── system/
├── writable/
├── vendor/
├── .env
├── composer.json
└── spark
```

**Cara Upload:**
- Klik **"Upload"** di File Manager
- Pilih semua file dan folder
- Tunggu hingga upload selesai
- **PENTING:** Pastikan struktur folder tetap sama seperti di local

#### Opsi B: Menggunakan FTP (FileZilla, WinSCP, dll)

1. Buka aplikasi FTP client (FileZilla)
2. Koneksi ke server Rumah Web:
   - **Host:** `ftp.madaniyatsicreative.web.id` atau IP server
   - **Username:** username hosting Anda
   - **Password:** password hosting Anda
   - **Port:** 21 (FTP) atau 22 (SFTP)
3. Navigasi ke: `/home/username/it.madaniyatsicreative.web.id/`
4. Upload semua file dan folder
5. Pastikan mode transfer: **Binary** untuk file, **ASCII** untuk text

#### Opsi C: Menggunakan Git (jika tersedia)

1. SSH ke server (jika akses SSH tersedia)
2. Clone repository:
```bash
cd /home/username/it.madaniyatsicreative.web.id/
git clone https://github.com/username/repository.git .
```

---

### 3. Setup Database MySQL

1. Login ke cPanel
2. Buka **"MySQL Databases"** atau **"MySQL Database Wizard"**
3. Buat database baru:
   - **Database Name:** `username_itportal` (atau nama lain)
   - Klik **"Create Database"**
4. Buat user database:
   - **Username:** `username_ituser` (atau nama lain)
   - **Password:** Buat password yang kuat
   - Klik **"Create User"**
5. Berikan privileges:
   - Pilih database dan user yang baru dibuat
   - Berikan **"ALL PRIVILEGES"**
   - Klik **"Make Changes"**
6. **Catat informasi berikut:**
   - Database name: `username_itportal`
   - Database user: `username_ituser`
   - Database password: `password_anda`
   - Database host: Biasanya `localhost` (cek di cPanel)

---

### 4. Konfigurasi File .env

1. Di File Manager, buka folder: `/home/username/it.madaniyatsicreative.web.id/`
2. Cari file `.env` (jika tidak ada, buat file baru)
3. Edit file `.env` dengan konfigurasi berikut:

```env
#--------------------------------------------------------------------
# ENVIRONMENT
#--------------------------------------------------------------------
CI_ENVIRONMENT = production

#--------------------------------------------------------------------
# APP
#--------------------------------------------------------------------
# Ganti dengan URL subdomain Anda
app.baseURL = 'https://it.madaniyatsicreative.web.id/'

#--------------------------------------------------------------------
# DATABASE
#--------------------------------------------------------------------
# Ganti dengan informasi database dari langkah 3
database.default.hostname = localhost
database.default.database = username_itportal
database.default.username = username_ituser
database.default.password = password_anda
database.default.DBDriver = MySQLi
database.default.port = 3306

#--------------------------------------------------------------------
# SECURITY
#--------------------------------------------------------------------
# Generate encryption key (lihat langkah 5)
encryption.key = 

#--------------------------------------------------------------------
# SESSION
#--------------------------------------------------------------------
session.driver = CodeIgniter
session.cookieName = ci_session
session.expiration = 7200
session.savePath = WRITEPATH . 'session'
session.matchIP = false
session.timeToUpdate = 300
session.regenerateDestroy = false

#--------------------------------------------------------------------
# LOGGER
#--------------------------------------------------------------------
# Untuk production, set ke 1 (ERROR saja)
logger.threshold = 1
```

**PENTING:**
- Ganti `username_itportal` dengan nama database yang Anda buat
- Ganti `username_ituser` dengan username database yang Anda buat
- Ganti `password_anda` dengan password database yang Anda buat
- Pastikan `app.baseURL` sesuai dengan subdomain Anda

---

### 5. Generate Encryption Key

1. SSH ke server (jika akses SSH tersedia):
```bash
cd /home/username/it.madaniyatsicreative.web.id/
php spark key:generate
```

2. **Jika tidak ada akses SSH**, generate key secara manual:
   - Buka terminal di local
   - Jalankan: `php spark key:generate`
   - Copy key yang dihasilkan
   - Paste ke file `.env` di bagian `encryption.key`

**Atau** generate key online di: https://randomkeygen.com/
- Pilih "CodeIgniter Encryption Keys"
- Copy salah satu key
- Paste ke `.env`

---

### 6. Set File Permissions

1. Di File Manager, set permission untuk folder berikut:

**Folder `writable/`:**
- Klik kanan folder `writable/`
- Pilih **"Change Permissions"** atau **"Permissions"**
- Set ke: **755** atau **775**
- Centang **"Recurse into subdirectories"**
- Klik **"Change Permissions"**

**Folder `public/uploads/`:**
- Navigasi ke: `public/uploads/`
- Set permission: **755**
- Pastikan subfolder juga: `public/uploads/news/` dan `public/uploads/pegawai/` → **755**

**Cara via SSH (jika tersedia):**
```bash
cd /home/username/it.madaniyatsicreative.web.id/
chmod -R 755 writable/
chmod -R 755 public/uploads/
```

---

### 7. Install Dependencies (Composer)

**Jika akses SSH tersedia:**

1. SSH ke server
2. Navigasi ke folder aplikasi:
```bash
cd /home/username/it.madaniyatsicreative.web.id/
```
3. Install dependencies:
```bash
composer install --no-dev --optimize-autoloader
```

**Jika tidak ada akses SSH:**

1. Install dependencies di local:
```bash
composer install --no-dev --optimize-autoloader
```
2. Upload folder `vendor/` ke server

---

### 8. Jalankan Migration Database

**Jika akses SSH tersedia:**

```bash
cd /home/username/it.madaniyatsicreative.web.id/
php spark migrate
```

**Jika tidak ada akses SSH:**

1. Import database secara manual:
   - Buka **phpMyAdmin** di cPanel
   - Pilih database yang sudah dibuat
   - Klik **"Import"**
   - Upload file SQL (jika ada)
   - Atau jalankan SQL berikut:

```sql
-- Tabel pegawai
CREATE TABLE IF NOT EXISTS `pegawai` (
  `id_pegawai` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nama_pegawai` varchar(150) NOT NULL,
  `tanggal_lahir` date DEFAULT NULL,
  `jenis_kelamin` enum('laki-laki','perempuan') DEFAULT 'laki-laki',
  `divisi` enum('Direktur Utama','IT','Produksi','Marketing','HR') DEFAULT 'IT',
  `foto_pegawai` varchar(255) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id_pegawai`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabel news (jika belum ada)
CREATE TABLE IF NOT EXISTS `news` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `author` varchar(100) DEFAULT 'John Doe',
  `content` text,
  `image_path` varchar(255) DEFAULT NULL,
  `status` enum('published','draft') DEFAULT 'draft',
  `slug` varchar(100) DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabel admins (jika belum ada)
CREATE TABLE IF NOT EXISTS `admins` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `role` varchar(50) DEFAULT 'admin',
  `is_active` tinyint(1) DEFAULT 1,
  `last_login_at` datetime DEFAULT NULL,
  `last_password_reset_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
```

---

### 9. Konfigurasi .htaccess

1. Di File Manager, buka folder: `public/`
2. Pastikan file `.htaccess` ada dengan isi:

```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteBase /
    
    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]
    
    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]
    
    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^ index.php [L]
</IfModule>
```

3. Jika tidak ada, buat file baru dengan nama `.htaccess`

---

### 10. Konfigurasi Document Root

**PENTING:** Di Rumah Web, untuk subdomain, pastikan Document Root mengarah ke folder `public/`:

1. Di cPanel, buka **"Subdomains"**
2. Edit subdomain `it.madaniyatsicreative.web.id`
3. Pastikan **Document Root** adalah:
   ```
   /home/username/it.madaniyatsicreative.web.id/public_html
   ```
4. **Atau** jika struktur folder berbeda, sesuaikan:
   - Jika file `public/` ada di: `/home/username/it.madaniyatsicreative.web.id/public/`
   - Maka Document Root harus: `/home/username/it.madaniyatsicreative.web.id/public/`

**Cara Alternatif (jika tidak bisa edit Document Root):**

1. Buat file `index.php` di folder `public_html/` dengan isi:
```php
<?php
// Path ke folder aplikasi (sesuaikan dengan struktur folder Anda)
$path = __DIR__ . '/../public/index.php';
require $path;
```

---

### 11. Setup SSL Certificate (HTTPS)

1. Di cPanel, cari **"SSL/TLS"** atau **"Let's Encrypt"**
2. Pilih subdomain: `it.madaniyatsicreative.web.id`
3. Klik **"Run AutoSSL"** atau **"Install SSL"**
4. Tunggu hingga SSL terpasang (biasanya beberapa menit)
5. Setelah SSL aktif, update `.env`:
```env
app.forceGlobalSecureRequests = true
```

---

### 12. Testing

1. Buka browser, akses: `https://it.madaniyatsicreative.web.id/`
2. Test halaman:
   - ✅ Halaman beranda
   - ✅ Halaman About
   - ✅ Halaman News
   - ✅ Login admin: `https://it.madaniyatsicreative.web.id/login`
3. Test fitur admin:
   - ✅ Login dengan kredensial admin
   - ✅ Tambah pegawai
   - ✅ Edit pegawai
   - ✅ Upload foto
   - ✅ Hapus pegawai

---

## 🔧 Troubleshooting

### Error: 500 Internal Server Error

**Penyebab:**
- File permission salah
- Error di file `.env`
- PHP version tidak sesuai

**Solusi:**
1. Cek file permission folder `writable/` → harus 755
2. Cek file `.env` → pastikan tidak ada typo
3. Cek PHP version di cPanel → harus PHP 8.1 atau lebih tinggi
4. Cek error log di cPanel → **"Errors"** atau **"Error Log"**

### Error: Database Connection Failed

**Penyebab:**
- Kredensial database salah
- Database host bukan `localhost`

**Solusi:**
1. Cek file `.env` → pastikan username, password, database name benar
2. Cek database host → di Rumah Web biasanya `localhost`
3. Test koneksi via phpMyAdmin

### Error: File Not Found / 404

**Penyebab:**
- Document Root salah
- File `.htaccess` tidak ada atau salah

**Solusi:**
1. Cek Document Root di cPanel → harus mengarah ke folder `public/`
2. Cek file `.htaccess` di folder `public/`
3. Pastikan mod_rewrite aktif (biasanya sudah aktif di Rumah Web)

### Error: Permission Denied

**Penyebab:**
- File permission terlalu ketat
- Owner file salah

**Solusi:**
1. Set permission folder `writable/` → 755
2. Set permission folder `public/uploads/` → 755
3. Via File Manager, pastikan owner file adalah username hosting Anda

### Foto Tidak Muncul

**Penyebab:**
- Folder `uploads/` tidak ada
- Permission folder salah
- Path file salah

**Solusi:**
1. Buat folder: `public/uploads/news/` dan `public/uploads/pegawai/`
2. Set permission: 755
3. Cek path di database → harus relatif: `uploads/pegawai/filename.jpg`

---

## 📝 Checklist Deployment

Gunakan checklist ini untuk memastikan semua langkah sudah dilakukan:

- [ ] Subdomain sudah dibuat di cPanel
- [ ] Semua file sudah diupload ke server
- [ ] Database sudah dibuat dan user sudah diberikan privileges
- [ ] File `.env` sudah dikonfigurasi dengan benar
- [ ] Encryption key sudah di-generate
- [ ] Permission folder `writable/` sudah di-set (755)
- [ ] Permission folder `public/uploads/` sudah di-set (755)
- [ ] Dependencies sudah diinstall (composer)
- [ ] Migration database sudah dijalankan
- [ ] File `.htaccess` sudah ada di folder `public/`
- [ ] Document Root sudah benar
- [ ] SSL certificate sudah terpasang
- [ ] Halaman website sudah bisa diakses
- [ ] Login admin sudah berfungsi
- [ ] Fitur CRUD pegawai sudah berfungsi
- [ ] Upload foto sudah berfungsi

---

## 🔐 Keamanan Post-Deployment

Setelah deployment berhasil, lakukan hal berikut:

1. **Ubah Password Admin Default**
   - Login ke admin panel
   - Ganti password admin dengan password yang kuat

2. **Hapus File yang Tidak Perlu**
   - Hapus file `README.md`, `DEPLOYMENT.md` dari server (opsional)
   - Jangan hapus file penting seperti `.env`, `composer.json`

3. **Set Environment ke Production**
   - Pastikan `CI_ENVIRONMENT = production` di `.env`
   - Pastikan `logger.threshold = 1` (hanya error)

4. **Backup Rutin**
   - Backup database secara rutin
   - Backup file aplikasi secara rutin

5. **Monitor Error Log**
   - Cek error log di cPanel secara berkala
   - Monitor aktivitas mencurigakan

---

## 📞 Support

Jika mengalami masalah:

1. **Cek Error Log** di cPanel
2. **Cek Dokumentasi** CodeIgniter 4
3. **Hubungi Support Rumah Web** jika masalah terkait hosting
4. **Cek File Permission** dan struktur folder

---

## 🎯 Informasi Penting

### URL Aplikasi
- **Public:** `https://it.madaniyatsicreative.web.id/`
- **Admin:** `https://it.madaniyatsicreative.web.id/admin`
- **Login:** `https://it.madaniyatsicreative.web.id/login`

### Struktur Folder di Server
```
/home/username/it.madaniyatsicreative.web.id/
├── app/
├── public/          → Document Root
│   ├── index.php
│   ├── .htaccess
│   ├── css/
│   ├── js/
│   ├── media/
│   └── uploads/
├── system/
├── writable/
├── vendor/
├── .env
└── composer.json
```

### Database Info
- **Host:** localhost
- **Database:** username_itportal (sesuaikan)
- **User:** username_ituser (sesuaikan)
- **Password:** (password yang Anda buat)

---

**Selamat! Aplikasi Anda sudah siap digunakan di production.**




