# Panduan Keamanan

Dokumen ini menjelaskan langkah-langkah keamanan yang telah diterapkan dan yang perlu dilakukan sebelum hosting.

## Keamanan yang Sudah Diterapkan

### 1. XSS (Cross-Site Scripting) Protection
- Semua output user menggunakan fungsi `esc()` untuk mencegah XSS
- Content dari database di-escape sebelum ditampilkan
- File yang sudah diperbaiki:
  - `app/Views/contact.php`
  - `app/Views/faqs.php`
  - `app/Views/news_detail.php`

### 2. CSRF (Cross-Site Request Forgery) Protection
- CSRF protection diaktifkan untuk semua form
- Token CSRF otomatis di-generate dan divalidasi
- Semua form admin sudah menggunakan `csrf_field()`

### 3. SQL Injection Protection
- Menggunakan CodeIgniter Query Builder (parameterized queries)
- Semua input user di-validate sebelum digunakan dalam query
- Tidak ada raw SQL query yang menggunakan user input langsung

### 4. Input Validation
- Semua form memiliki validasi yang ketat
- File upload divalidasi (tipe file, ukuran, MIME type)
- Input dibersihkan sebelum disimpan ke database

### 5. Authentication & Authorization
- Admin routes dilindungi dengan `AuthFilter`
- Session management yang aman
- Password di-hash menggunakan `password_hash()`

### 6. File Upload Security
- Validasi tipe file (hanya gambar: JPG, JPEG, PNG, WEBP)
- Validasi ukuran file (maksimal 2MB)
- Validasi MIME type
- File disimpan dengan nama random untuk mencegah path traversal

## Checklist Sebelum Hosting

### 1. Environment Configuration
- [ ] Ubah `CI_ENVIRONMENT` menjadi `production` di file `.env`
- [ ] Set `app.baseURL` sesuai domain hosting Anda
- [ ] Generate encryption key baru: `php spark key:generate`
- [ ] Set `logger.threshold` menjadi `1` (ERROR saja) untuk production

### 2. Database Configuration
- [ ] Update konfigurasi database di `.env` dengan kredensial production
- [ ] Pastikan database user memiliki privilege minimal yang diperlukan
- [ ] Backup database sebelum deploy

### 3. File Permissions
- [ ] Set permission `writable/` folder menjadi `755` atau `775`
- [ ] Pastikan web server memiliki akses write ke folder `writable/`
- [ ] Set permission `public/uploads/` menjadi `755`

### 4. Security Headers
- [ ] Aktifkan HTTPS di hosting
- [ ] Set `app.forceGlobalSecureRequests = true` jika menggunakan HTTPS
- [ ] Aktifkan `secureheaders` filter di `app/Config/Filters.php` jika diperlukan

### 5. CSRF Configuration
- [ ] Pastikan `csrfProtection` sudah diaktifkan (sudah aktif)
- [ ] Set `csrf.regenerate = true` (sudah aktif)
- [ ] Set `csrf.redirect = true` untuk production

### 6. Error Handling
- [ ] Pastikan error display dimatikan di production
- [ ] Set `app.indexPage = ''` jika menggunakan URL rewriting
- [ ] Pastikan file `.env` tidak bisa diakses dari browser (sudah di-handle oleh `.htaccess`)

### 7. File yang Harus Dihapus/Diabaikan
- [ ] Pastikan `.env` tidak di-commit ke repository
- [ ] Hapus file development/testing yang tidak diperlukan
- [ ] Pastikan `writable/logs/` tidak bisa diakses dari browser

## Best Practices

1. **Password Policy**: Pastikan admin menggunakan password yang kuat
2. **Regular Updates**: Update CodeIgniter dan dependencies secara berkala
3. **Backup**: Lakukan backup database dan file secara berkala
4. **Monitoring**: Monitor log error untuk mendeteksi serangan atau masalah
5. **HTTPS**: Selalu gunakan HTTPS untuk production

## Catatan Penting

- Jangan pernah commit file `.env` ke repository
- Jangan gunakan encryption key yang sama untuk development dan production
- Selalu gunakan `esc()` untuk output user di view
- Validasi semua input sebelum digunakan
- Gunakan prepared statements untuk query database




