<?php

namespace App\Controllers;

use App\Models\ActivityModel;

class Activities extends BaseController
{
    private ActivityModel $activities;

    public function __construct()
    {
        helper(['text']);
        $this->activities = new ActivityModel();
    }

    public function index(): string
    {
        $request    = $this->request;
        $search     = trim((string) $request->getGet('q'));
        $mediaType  = (string) $request->getGet('media');
        $sort       = (string) $request->getGet('sort');
        $dateFilter = (string) $request->getGet('date');

        $query = $this->activities;

        if ($search !== '') {
            $query->groupStart()
                ->like('title', $search)
                ->orLike('description', $search)
                ->orLike('location', $search)
                ->groupEnd();
        }

        if (in_array($mediaType, ['image', 'video', 'none'], true)) {
            $query->where('media_type', $mediaType);
        }

        if ($dateFilter !== '') {
            if (preg_match('/^\\d{4}-\\d{2}-\\d{2}$/', $dateFilter)) {
                $query->where('activity_date', $dateFilter);
            } elseif (preg_match('/^\\d{4}-\\d{2}$/', $dateFilter)) {
                $startDate = $dateFilter . '-01';
                $endDate   = date('Y-m-t', strtotime($startDate));
                $query->where('activity_date >=', $startDate)
                    ->where('activity_date <=', $endDate);
            }
        }

        $sort = $sort !== '' ? $sort : 'date_desc';
        switch ($sort) {
            case 'date_asc':
                $query->orderBy('activity_date', 'asc')->orderBy('activity_time', 'asc');
                break;
            case 'name_asc':
                $query->orderBy('title', 'asc');
                break;
            case 'name_desc':
                $query->orderBy('title', 'desc');
                break;
            default:
                $query->orderBy('activity_date', 'desc')->orderBy('activity_time', 'desc');
                $sort = 'date_desc';
        }

        $activities = $query->paginate(10, 'activities');

        return view('activities', [
            'activities' => $activities,
            'pager'      => $this->activities->pager,
            'filters'    => [
                'search' => $search,
                'media'  => $mediaType !== '' ? $mediaType : 'semua',
                'date'   => $dateFilter,
                'sort'   => $sort,
            ],
        ]);
    }
}
