<?php

namespace App\Controllers;

use App\Models\EducationModel;

class Education extends BaseController
{
    private EducationModel $education;

    public function __construct()
    {
        $this->education = new EducationModel();
    }

    public function index(): string
    {
        $request     = $this->request;
        $search      = trim((string) $request->getGet('q'));
        $degree      = trim((string) $request->getGet('degree'));
        $sort        = (string) $request->getGet('sort');
        $startYear   = (int) $request->getGet('start_year');
        $endYear     = (int) $request->getGet('end_year');

        $query = $this->education;

        if ($search !== '') {
            $query->groupStart()
                ->like('institution', $search)
                ->orLike('field_of_study', $search)
                ->orLike('description', $search)
                ->groupEnd();
        }

        if ($degree !== '' && $degree !== 'semua') {
            $query->where('degree', $degree);
        }

        if ($startYear > 0) {
            $query->where('start_year >=', $startYear);
        }

        if ($endYear > 0) {
            $query->groupStart()
                ->where('end_year <=', $endYear)
                ->orWhere('end_year', null)
                ->groupEnd();
        }

        $sort = $sort !== '' ? $sort : 'start_desc';
        switch ($sort) {
            case 'start_asc':
                $query->orderBy('start_year', 'asc');
                break;
            case 'degree':
                $query->orderBy('degree', 'asc')->orderBy('start_year', 'desc');
                break;
            default:
                $query->orderBy('start_year', 'desc');
                $sort = 'start_desc';
        }

        $records = $query->paginate(10, 'education');

        $degrees = ['SD', 'SMP', 'SMA/SMK', 'Diploma', 'Sarjana', 'Magister', 'Doktor', 'Lainnya'];

        return view('education', [
            'records' => $records,
            'pager'   => $this->education->pager,
            'filters' => [
                'search'     => $search,
                'degree'     => $degree !== '' ? $degree : 'semua',
                'start_year' => $startYear > 0 ? $startYear : '',
                'end_year'   => $endYear > 0 ? $endYear : '',
                'sort'       => $sort,
            ],
            'degreeOptions' => $degrees,
        ]);
    }
}
