<?php

namespace App\Controllers;

use App\Models\PegawaiModel;

/**
 * Controller untuk halaman statis (About, Contact, FAQs).
 */
class Page extends BaseController
{
    /**
     * Menampilkan halaman About dengan daftar pegawai.
     */
    public function about()
    {
        $pegawaiModel = new PegawaiModel();

        $search       = trim((string) $this->request->getGet('q'));
        $divisiFilter = (string) $this->request->getGet('divisi');
        $genderFilter = (string) $this->request->getGet('jenis_kelamin');

        $query = $pegawaiModel->orderBy('id_pegawai', 'asc');

        if ($search !== '') {
            $query->like('nama_pegawai', $search);
        }

        if ($divisiFilter !== '' && $divisiFilter !== 'semua') {
            $query->where('divisi', $divisiFilter);
        }

        if ($genderFilter !== '' && $genderFilter !== 'semua') {
            $query->where('jenis_kelamin', $genderFilter);
        }

        $pegawai = $query->findAll();

        return view('about', [
            'pegawai'    => $pegawai,
            'filters'    => [
                'search'        => $search,
                'divisi'        => $divisiFilter !== '' ? $divisiFilter : 'semua',
                'jenis_kelamin' => $genderFilter !== '' ? $genderFilter : 'semua',
            ],
            'showHeader' => false,
        ]);
    }

    /**
     * Menampilkan halaman Contact.
     */
    public function contact()
    {
        $data = [
            'name' => 'MADANI YATSI CREATIVE',
        ];

        return view('contact', $data);
    }

    /**
     * Menampilkan halaman FAQs (Frequently Asked Questions).
     */
    public function faqs()
    {
        $data = [
            'data_faqs' => [
                [
                    'question' => 'Apa itu Codeigniter?',
                    'answer'   => 'Codeigniter adalah framework untuk membuat web',
                ],
                [
                    'question' => 'Siapa yang membuat Codeigniter?',
                    'answer'   => 'CI awalnya dibuat oleh Ellislab',
                ],
                [
                    'question' => 'Codeigniter versi berapakah yang digunakan pada tutorial ini?',
                    'answer'   => 'Codeigniter versi 4.0.4',
                ],
            ],
        ];

        return view('faqs', $data);
    }
}
