<?php

namespace App\Controllers;

use App\Models\ActivityModel;
use App\Models\BiodataModel;
use App\Models\EducationModel;

class Portfolio extends BaseController
{
    public function index(): string
    {
        $biodataModel    = new BiodataModel();
        $activityModel   = new ActivityModel();
        $educationModel  = new EducationModel();

        $profile   = $biodataModel->orderBy('id', 'asc')->first();
        $activities = $activityModel->orderBy('activity_date', 'desc')->orderBy('activity_time', 'desc')->findAll(5);
        $education  = $educationModel->orderBy('start_year', 'desc')->findAll(5);

        return view('portfolio_home', [
            'profile'    => $profile,
            'activities' => $activities,
            'education'  => $education,
        ]);
    }
}
