<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEducationHistories extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 10,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'institution' => [
                'type'       => 'VARCHAR',
                'constraint' => 150,
            ],
            'degree' => [
                'type'       => 'ENUM',
                'constraint' => ['SD', 'SMP', 'SMA/SMK', 'Diploma', 'Sarjana', 'Magister', 'Doktor', 'Lainnya'],
                'default'    => 'Sarjana',
            ],
            'field_of_study' => [
                'type'       => 'VARCHAR',
                'constraint' => 150,
                'null'       => true,
            ],
            'city' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
                'null'       => true,
            ],
            'start_year' => [
                'type'       => 'INT',
                'constraint' => 4,
                'unsigned'   => true,
            ],
            'end_year' => [
                'type'       => 'INT',
                'constraint' => 4,
                'unsigned'   => true,
                'null'       => true,
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at DATETIME DEFAULT CURRENT_TIMESTAMP',
            'updated_at DATETIME NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP',
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addKey('degree');
        $this->forge->addKey('start_year');
        $this->forge->createTable('education_histories', true);
    }

    public function down()
    {
        $this->forge->dropTable('education_histories', true);
    }
}
