<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class ActivitySeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'activity_date' => date('Y-m-d', strtotime('-2 days')),
                'activity_time' => '08:00:00',
                'title'         => 'Rapat kickoff proyek akhir',
                'description'   => 'Menyepakati scope tugas individu dan alur kerja harian.',
                'location'      => 'Ruang rapat A',
                'media_type'    => 'image',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-1 day')),
                'activity_time' => '10:30:00',
                'title'         => 'Implementasi modul autentikasi',
                'description'   => 'Menyelesaikan login admin dan proteksi route.',
                'location'      => 'Laboratorium SI',
                'media_type'    => 'none',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d'),
                'activity_time' => '14:00:00',
                'title'         => 'Membangun CRUD aktivitas harian',
                'description'   => 'Mendesain tabel, validasi, serta upload foto atau video.',
                'location'      => 'Perpustakaan',
                'media_type'    => 'image',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-5 days')),
                'activity_time' => '19:00:00',
                'title'         => 'Rekam demo LMS SIAma',
                'description'   => 'Menyiapkan rekaman presentasi berdurasi 5 menit.',
                'location'      => 'Rumah',
                'media_type'    => 'video',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-3 days')),
                'activity_time' => '16:00:00',
                'title'         => 'Uji coba upload dokumen',
                'description'   => 'Memastikan validasi file dan penyimpanan berjalan aman.',
                'location'      => 'Laboratorium SI',
                'media_type'    => 'image',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-4 days')),
                'activity_time' => '11:30:00',
                'title'         => 'Review kode modul pendidikan',
                'description'   => 'Code review untuk konsistensi style dan keamanan input.',
                'location'      => 'Perpustakaan',
                'media_type'    => 'none',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-6 days')),
                'activity_time' => '09:15:00',
                'title'         => 'Sinkronisasi API berita',
                'description'   => 'Integrasi endpoint berita dan penanganan error fallback.',
                'location'      => 'Ruang rapat B',
                'media_type'    => 'image',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-7 days')),
                'activity_time' => '15:45:00',
                'title'         => 'Analisis performa query',
                'description'   => 'Profiling query berat dan menambahkan indeks yang diperlukan.',
                'location'      => 'Laboratorium SI',
                'media_type'    => 'none',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-8 days')),
                'activity_time' => '13:20:00',
                'title'         => 'Rapat kebutuhan fitur baru',
                'description'   => 'Mengumpulkan requirement untuk fitur pengelolaan portfolio.',
                'location'      => 'Ruang rapat A',
                'media_type'    => 'none',
                'media_path'    => null,
            ],
            [
                'activity_date' => date('Y-m-d', strtotime('-9 days')),
                'activity_time' => '10:00:00',
                'title'         => 'Desain ulang layout dashboard',
                'description'   => 'Menyusun sketsa UX dan tema warna untuk panel admin.',
                'location'      => 'Perpustakaan',
                'media_type'    => 'image',
                'media_path'    => null,
            ],
        ];

        $this->db->table('daily_activities')->insertBatch($data);
    }
}
