<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $companyName = 'Dimas Cahya Ramadhan';

    $resolveAsset = static function ($candidates) {
        $candidates = (array) $candidates;

        foreach ($candidates as $candidate) {
            $relative = ltrim($candidate, '/');
            $path     = FCPATH . $relative;

            if (is_file($path)) {
                $version = filemtime($path);

                return [
                    'exists'   => true,
                    'relative' => $relative,
                    'url'      => base_url($relative) . '?v=' . $version,
                ];
            }
        }

        $relative = ltrim($candidates[0], '/');

        return [
            'exists'   => false,
            'relative' => $relative,
            'url'      => base_url($relative) . '?v=' . time(),
        ];
    };

    // Pakai fallback visual (gradien) agar konsisten dengan tema portofolio pribadi.
    // Pakai gradien (tanpa foto gedung) untuk hero About.
    $bannerAsset = ['exists' => false, 'url' => ''];
    $logoAsset   = $resolveAsset(['media/logoPT.png', 'logoPT.png']);

    $makeInitials = static function (string $text, int $length = 2): string {
        $text = trim($text);

        if ($text === '') {
            return 'MY';
        }

        $parts   = preg_split('/\s+/', $text);
        $letters = '';

        foreach ($parts as $part) {
            $letters .= function_exists('mb_substr') ? mb_substr($part, 0, 1, 'UTF-8') : substr($part, 0, 1);

            if (strlen($letters) >= $length) {
                break;
            }
        }

        $letters = strtoupper(substr($letters, 0, $length));

        return $letters !== '' ? $letters : 'MY';
    };

    $stats = [
        [
            'value' => '120+',
            'label' => 'Proyek Digital',
            'desc'  => 'Produk kreatif dan solusi teknologi diluncurkan bersama klien nasional.',
        ],
        [
            'value' => '45',
            'label' => 'Talenta Ahli',
            'desc'  => 'Tim lintas disiplin dengan fokus pada pengalaman digital end-to-end.',
        ],
        [
            'value' => '98%',
            'label' => 'Kepuasan Klien',
            'desc'  => 'Kolaborasi jangka panjang yang terjaga melalui komunikasi adaptif.',
        ],
    ];

    $coreValues = [
        [
            'title' => 'Kolaboratif',
            'desc'  => 'Sinergi antardivisi membuat laju inovasi merata dari strategi hingga eksekusi.',
        ],
        [
            'title' => 'Data-Driven',
            'desc'  => 'Setiap keputusan berbasis insight agar solusi yang diambil relevan dan terukur.',
        ],
        [
            'title' => 'Berdaya Guna',
            'desc'  => 'Produk fokus pada dampak nyata: membantu bisnis tumbuh dan pengguna merasa terbantu.',
        ],
    ];

    $milestones = [
        [
            'year'  => '2016',
            'title' => 'Awal Perjalanan',
            'desc'  => 'Tim kecil YAMA Creative merampungkan proyek kampanye digital perdana.',
        ],
        [
            'year'  => '2018',
            'title' => 'Formalisasi Perusahaan',
            'desc'  => $companyName . ' resmi berdiri dan mulai membangun lini layanan terpadu.',
        ],
        [
            'year'  => '2021',
            'title' => 'Ekspansi Layanan',
            'desc'  => 'Menambah divisi produk dan teknologi untuk mendukung skalabilitas klien.',
        ],
        [
            'year'  => '2024',
            'title' => 'Penguatan Budaya',
            'desc'  => 'Mengadopsi sistem kerja hybrid dan playbook kolaborasi lintas divisi.',
        ],
    ];

    $divisiList = ['Direktur Utama', 'IT', 'HR', 'Produksi', 'Marketing'];
    $divisiLabels = [
        'Direktur Utama' => 'Direktur Utama',
        'IT'             => 'IT (Information Technology)',
        'HR'             => 'HR (Human Resource)',
        'Produksi'       => 'Produksi',
        'Marketing'      => 'Marketing',
        'Lainnya'        => 'Divisi Pendukung',
    ];

    $groupedPegawai = [];

    foreach ($pegawai ?? [] as $pegawaiItem) {
        $divisi = $pegawaiItem['divisi'] ?? 'Lainnya';

        $groupedPegawai[$divisi][] = $pegawaiItem;

        if (! in_array($divisi, $divisiList, true) && $divisi !== 'Lainnya') {
            $divisiList[] = $divisi;
        }
    }

    if (isset($groupedPegawai['Lainnya']) && ! in_array('Lainnya', $divisiList, true)) {
        $divisiList[] = 'Lainnya';
    }

    $filters = isset($filters) && is_array($filters) ? $filters : [];
    $filters = array_merge([
        'search'        => '',
        'divisi'        => 'semua',
        'jenis_kelamin' => 'semua',
    ], $filters);
    $hasFilters = $filters['search'] !== '' || $filters['divisi'] !== 'semua' || $filters['jenis_kelamin'] !== 'semua';
    $activeFilterCount = 0;
    $activeFilterCount += $filters['search'] !== '' ? 1 : 0;
    $activeFilterCount += $filters['divisi'] !== 'semua' ? 1 : 0;
    $activeFilterCount += $filters['jenis_kelamin'] !== 'semua' ? 1 : 0;
    $pegawaiCount = is_array($pegawai ?? null) ? count($pegawai) : 0;

    $resolvePhoto = static function (?string $path) {
        if (empty($path)) {
            return ['exists' => false, 'url' => ''];
        }

        $relative = ltrim($path, '/');
        $fullPath = FCPATH . $relative;

        if (! is_file($fullPath)) {
            $altPath = FCPATH . 'uploads/' . basename($relative);

            if (is_file($altPath)) {
                $relative = 'uploads/' . basename($relative);
                $fullPath = $altPath;
            }
        }

        if (! is_file($fullPath)) {
            return ['exists' => false, 'url' => ''];
        }

        $version = filemtime($fullPath);

        return [
            'exists' => true,
            'url'    => base_url($relative) . '?v=' . $version,
        ];
    };

    $companyInitials = $makeInitials($companyName);
?>
<style>
.page-about {
    position: relative;
}
.page-about::before {
    content: "";
    position: absolute;
    inset: 0;
    background:
        radial-gradient(circle at 12% 18%, rgba(139, 92, 246, 0.12), transparent 48%),
        radial-gradient(circle at 86% 16%, rgba(34, 211, 238, 0.2), transparent 50%);
    opacity: 0.85;
    pointer-events: none;
}
.page-about > .container {
    position: relative;
    z-index: 1;
    padding-bottom: 4rem !important;
}
.about-hero {
    position: relative;
    border-radius: 32px;
    overflow: hidden;
    background: linear-gradient(140deg, #0b1220, #111e3b);
    box-shadow: 0 28px 56px rgba(15, 23, 42, 0.42);
    margin-bottom: 3.5rem;
}
.about-hero--split {
    display: grid;
    grid-template-columns: minmax(0, 1.05fr) minmax(0, 1fr);
    align-items: stretch;
    min-height: clamp(380px, 52vw, 580px);
}
.about-hero__visual {
    position: relative;
    overflow: hidden;
}
.about-hero__visual img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.about-hero__visual::after {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(110deg, rgba(11, 17, 30, 0.05) 0%, rgba(11, 17, 30, 0.45) 40%, rgba(11, 17, 30, 0.85) 100%);
}
.about-hero__visual-fallback {
    width: 100%;
    height: 100%;
    background:
        radial-gradient(circle at 22% 35%, rgba(14, 165, 233, 0.30), transparent 62%),
        radial-gradient(circle at 78% 18%, rgba(20, 184, 166, 0.24), transparent 58%),
        linear-gradient(135deg, #0b1220, #0e7490);
}
.about-hero__content {
    position: relative;
    z-index: 1;
    padding: clamp(40px, 6vw, 72px);
    display: grid;
    gap: 1.4rem;
    align-content: center;
    color: rgba(226, 232, 240, 0.92);
}
.about-hero__brand {
    display: inline-flex;
    align-items: center;
    gap: 0.75rem;
}
.about-hero__brand img,
.about-hero__brand .about-hero__brand-initials {
    width: clamp(56px, 5vw, 72px);
    height: clamp(56px, 5vw, 72px);
    border-radius: 18px;
    background: rgba(255, 255, 255, 0.12);
    border: 1px solid rgba(148, 163, 184, 0.18);
    display: grid;
    place-items: center;
    padding: 10px;
    box-shadow: 0 16px 32px rgba(15, 23, 42, 0.28);
}
.about-hero__brand img {
    object-fit: contain;
}
.about-hero__brand-initials {
    font-weight: 700;
    letter-spacing: 0.12em;
    color: #f8fafc;
    font-size: 18px;
}
.about-hero__brand span {
    font-weight: 700;
    letter-spacing: 0.05em;
    color: #f8fafc;
    text-transform: uppercase;
    font-size: clamp(0.95rem, 1.2vw, 1.15rem);
}
.about-hero__eyebrow {
    font-size: clamp(0.9rem, 1.2vw, 1.1rem);
    font-weight: 600;
    letter-spacing: 0.16em;
    text-transform: uppercase;
    color: rgba(45, 212, 191, 0.9);
}
.about-hero__title {
    margin: 0;
    font-size: clamp(28px, 5.5vw, 56px);
    font-weight: 700;
    color: #ffffff;
    line-height: 1.25;
}
.about-hero__lead {
    margin: 0;
    color: rgba(226, 232, 240, 0.84);
    line-height: 1.7;
    font-size: clamp(1rem, 1.3vw, 1.2rem);
}
.about-hero__chips {
    display: flex;
    flex-wrap: wrap;
    gap: 0.6rem;
    margin-top: 0.5rem;
}
.about-hero__chip {
    display: inline-flex;
    align-items: center;
    gap: 0.4rem;
    padding: 0.4rem 0.9rem;
    border-radius: 999px;
    background: rgba(79, 70, 229, 0.18);
    color: rgba(226, 232, 240, 0.92);
    font-size: 0.85rem;
    font-weight: 600;
}
.about-hero__chip::before {
    content: "✦";
    font-size: 0.8rem;
    color: rgba(34, 211, 238, 0.75);
}
.about-hero__cta {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
    align-items: center;
    margin-top: 0.5rem;
}
.btn-pill {
    border-radius: 999px;
    padding: 0.65rem 1.6rem;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 0.45rem;
    text-decoration: none;
}
.btn-pill--primary {
    background: linear-gradient(135deg, #1d4ed8, #16a34a);
    color: #fff;
    border: none;
    box-shadow: 0 18px 36px rgba(37, 99, 235, 0.35);
}
.btn-pill--primary:hover {
    color: #fff;
    background: linear-gradient(135deg, #1e40af, #15803d);
}
.btn-pill--ghost {
    background: rgba(148, 163, 184, 0.12);
    border: 1px solid rgba(148, 163, 184, 0.35);
    color: rgba(226, 232, 240, 0.9);
}
.btn-pill:hover {
    text-decoration: none;
}
.btn-pill--ghost:hover {
    color: #ffffff;
    background: rgba(148, 163, 184, 0.22);
}
.metric-card {
    background: rgba(248, 250, 255, 0.96);
    border-radius: 24px;
    padding: 24px;
    box-shadow: 0 22px 38px rgba(15, 23, 42, 0.1);
    border: 1px solid rgba(148, 163, 184, 0.18);
    height: 100%;
    display: flex;
    flex-direction: column;
    gap: 12px;
}
.metric-card__value {
    font-size: clamp(32px, 4vw, 48px);
    font-weight: 700;
    color: var(--brand-primary);
}
.metric-card__label {
    color: var(--brand-dark);
    font-weight: 600;
    margin-bottom: 4px;
    font-size: clamp(1rem, 1.1vw, 1.15rem);
}
.metric-card__desc {
    color: var(--text-muted);
    margin-bottom: 0;
    font-size: clamp(0.9rem, 1vw, 1rem);
}
.about-story {
    margin-top: 3rem;
    margin-bottom: 3rem;
}
.story-card,
.values-card {
    background: var(--surface-foreground);
    border-radius: 26px;
    padding: clamp(24px, 4vw, 32px);
    box-shadow: 0 24px 44px rgba(15, 23, 42, 0.1);
    border: 1px solid rgba(148, 163, 184, 0.15);
    height: 100%;
}
.story-card h2 {
    font-size: clamp(22px, 3vw, 32px);
    font-weight: 700;
    margin-bottom: 14px;
    color: var(--brand-dark);
}
.story-card p {
    color: var(--text-muted);
    margin-bottom: 0;
    font-size: clamp(1rem, 1.1vw, 1.1rem);
    line-height: 1.7;
}
.values-card h3 {
    font-size: clamp(20px, 2.5vw, 28px);
    font-weight: 700;
    margin-bottom: 16px;
    color: var(--brand-dark);
}
.values-list {
    list-style: none;
    padding: 0;
    margin: 0;
    display: grid;
    gap: 18px;
}
.values-list li {
    display: grid;
    gap: 6px;
    border-left: 4px solid var(--brand-secondary);
    padding-left: 16px;
}
.values-list strong {
    color: var(--brand-dark);
    font-size: 18px;
}
.values-list span {
    color: var(--text-muted);
    font-size: 15px;
}
.section-heading {
    margin-bottom: 28px;
}
.section-heading__label {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-size: 15px;
    font-weight: 600;
    color: var(--brand-primary);
    text-transform: uppercase;
    letter-spacing: 0.08em;
}
.section-heading__title {
    font-size: clamp(26px, 3.6vw, 34px);
    font-weight: 700;
    color: var(--brand-dark);
    margin-top: 8px;
    margin-bottom: 12px;
}
.section-heading__lead {
    color: var(--text-muted);
    max-width: 620px;
    margin-bottom: 0;
}
.tag-chip {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 6px 14px;
    border-radius: 999px;
    font-size: 13px;
    font-weight: 600;
}
.tag-chip--primary {
    background: rgba(59, 130, 246, 0.14);
    color: var(--brand-primary);
}
.tag-chip--success {
    background: rgba(16, 185, 129, 0.16);
    color: #0f766e;
}
.timeline {
    display: grid;
    gap: 18px;
}
.timeline__item {
    position: relative;
    padding: 20px 24px 20px 74px;
    background: var(--surface-foreground);
    border-radius: 20px;
    box-shadow: 0 22px 38px rgba(15, 23, 42, 0.08);
    border: 1px solid rgba(148, 163, 184, 0.18);
}
.timeline__item::before {
    content: attr(data-year);
    position: absolute;
    top: 50%;
    left: 24px;
    transform: translateY(-50%);
    font-weight: 700;
    color: var(--brand-primary);
    background: rgba(59, 130, 246, 0.14);
    padding: 8px 14px;
    border-radius: 14px;
}
.timeline__item h4 {
    font-size: 18px;
    font-weight: 600;
    color: var(--brand-dark);
    margin-bottom: 6px;
}
.timeline__item p {
    margin-bottom: 0;
    color: var(--text-muted);
}
.about-structure {
    margin-top: 2.5rem;
    margin-bottom: 3rem;
}
.pegawai-filter {
    background: linear-gradient(145deg, rgba(255, 255, 255, 0.95), rgba(236, 244, 255, 0.94));
    border: 1px solid rgba(148, 163, 184, 0.18);
    border-radius: 20px;
    padding: 26px 24px;
    box-shadow: 0 24px 54px rgba(15, 23, 42, 0.14);
    position: relative;
    overflow: hidden;
}
.pegawai-filter::after {
    content: "";
    position: absolute;
    inset: 0;
    background:
        radial-gradient(circle at 12% 12%, rgba(59, 130, 246, 0.13), transparent 42%),
        radial-gradient(circle at 86% 82%, rgba(52, 211, 153, 0.14), transparent 40%),
        linear-gradient(120deg, rgba(99, 102, 241, 0.08), rgba(59, 130, 246, 0.06), rgba(16, 185, 129, 0.08));
    border-radius: 20px;
    pointer-events: none;
}
.pegawai-filter__inner {
    position: relative;
    z-index: 1;
}
.pegawai-filter__header {
    display: flex;
    justify-content: space-between;
    gap: 12px;
    align-items: center;
    flex-wrap: wrap;
    margin-bottom: 8px;
}
.pegawai-filter__eyebrow {
    font-weight: 700;
    color: #2563eb;
    text-transform: uppercase;
    letter-spacing: 0.06em;
    font-size: 12px;
}
.pegawai-filter__summary {
    color: var(--text-muted);
    font-size: 13px;
}
.pegawai-filter .form-label {
    font-weight: 600;
    color: var(--brand-dark);
}
.pegawai-filter .input-group-text {
    background: rgba(255, 255, 255, 0.9);
    border-color: rgba(148, 163, 184, 0.45);
}
.pegawai-filter .form-control,
.pegawai-filter .form-select {
    border-radius: 12px;
    border: 1px solid rgba(148, 163, 184, 0.4);
    background: rgba(255, 255, 255, 0.85);
    transition: box-shadow 0.2s ease, transform 0.1s ease, border-color 0.2s ease;
}
.pegawai-filter .form-control:focus,
.pegawai-filter .form-select:focus {
    box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.22);
    transform: translateY(-1px);
}
.pegawai-filter .filter-actions {
    display: flex;
    gap: 14px;
    align-items: center;
    justify-content: flex-start;
    flex-wrap: wrap;
    margin-top: 4px;
}
.btn-responsive {
    width: 100%;
}
.btn-responsive--ghost {
    width: 100%;
}
@media (min-width: 992px) {
    .btn-responsive,
    .btn-responsive--ghost {
        width: auto;
    }
    .pegawai-filter .filter-actions {
        justify-content: flex-end;
        flex-wrap: nowrap;
    }
}
.pegawai-filter .form-select {
    appearance: none;
    background-image:
        linear-gradient(45deg, transparent 50%, #2563eb 50%),
        linear-gradient(135deg, #2563eb 50%, transparent 50%),
        linear-gradient(to right, #e5e7eb, #e5e7eb);
    background-position:
        calc(100% - 16px) calc(50% + 2px),
        calc(100% - 11px) calc(50% + 2px),
        calc(100% - 32px) 50%;
    background-size: 6px 6px, 6px 6px, 1px 60%;
    background-repeat: no-repeat;
    padding-right: 42px;
}
.btn-pill-primary {
    background: linear-gradient(120deg, #2563eb, #4f46e5);
    border: none;
    color: #fff;
    font-weight: 700;
    font-size: 15px;
    border-radius: 14px;
    padding: 11px 18px;
    min-width: 112px;
    box-shadow:
        0 14px 28px rgba(37, 99, 235, 0.28),
        0 0 0 8px rgba(59, 130, 246, 0.08);
    transition: transform 0.15s ease, box-shadow 0.15s ease, filter 0.15s ease;
    position: relative;
    overflow: hidden;
}
.btn-pill-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 16px 32px rgba(37, 99, 235, 0.32);
    filter: brightness(1.03);
}
.btn-pill-primary::after {
    content: "";
    position: absolute;
    inset: 0;
    background: radial-gradient(circle at 20% 20%, rgba(255, 255, 255, 0.28), transparent 45%);
    opacity: 0;
    transition: opacity 0.2s ease;
}
.btn-pill-primary:hover::after {
    opacity: 1;
}
.btn-pill-ghost {
    background: rgba(255, 255, 255, 0.9);
    border: 1px solid rgba(148, 163, 184, 0.6);
    color: var(--brand-dark);
    font-weight: 700;
    font-size: 15px;
    border-radius: 14px;
    padding: 11px 18px;
    min-width: 104px;
    transition: transform 0.15s ease, box-shadow 0.15s ease;
}
.btn-pill-ghost:hover {
    transform: translateY(-1px);
    box-shadow: 0 12px 24px rgba(148, 163, 184, 0.35);
}
.filter-chip {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 8px 12px;
    background: rgba(59, 130, 246, 0.1);
    border: 1px solid rgba(59, 130, 246, 0.26);
    border-radius: 999px;
    color: var(--brand-dark);
    font-weight: 600;
    font-size: 13px;
}
.filter-chip__label {
    color: var(--text-muted);
    text-transform: uppercase;
    letter-spacing: 0.05em;
    font-size: 11px;
}
.filter-chip__value {
    color: var(--brand-dark);
}
.division-group {
    margin-bottom: 3.5rem;
}
.division-group:last-child {
    margin-bottom: 0;
}
.division-group__header {
    display: flex;
    align-items: baseline;
    justify-content: space-between;
    gap: 16px;
    margin-bottom: 18px;
}
.division-group__title {
    font-size: clamp(18px, 2.2vw, 26px);
    font-weight: 700;
    color: var(--brand-dark);
    margin-bottom: 0;
}
.division-group__info {
    font-size: clamp(0.9rem, 1vw, 1rem);
    color: var(--text-muted);
    margin-bottom: 0;
}
.team-card {
    background: var(--surface-foreground);
    border-radius: 22px;
    box-shadow: 0 24px 44px rgba(15, 23, 42, 0.12);
    border: 1px solid rgba(148, 163, 184, 0.18);
    overflow: hidden;
    height: 100%;
    display: flex;
    flex-direction: column;
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    margin-bottom: 0.5rem;
}
.team-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 22px 42px rgba(15, 23, 42, 0.12);
}
.team-card__media {
    position: relative;
    background: rgba(224, 231, 255, 0.5);
    padding-top: 100%;
    border-radius: 16px;
    overflow: hidden;
}
.team-card__media a {
    display: block;
    height: 100%;
    color: inherit;
}
.team-card__media a:hover {
    text-decoration: none;
}
.team-card__media::before {
    content: "";
    position: absolute;
    inset: 0;
    background: radial-gradient(circle at 30% 30%, rgba(255, 255, 255, 0.4), transparent 50%);
    opacity: 0;
    transition: opacity 0.3s ease;
}
.team-card__media img,
.team-card__media .team-card__placeholder {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
}
.team-card__media img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center center;
}
.team-card__placeholder {
    display: grid;
    place-items: center;
    color: var(--brand-primary);
    font-weight: 700;
    font-size: 26px;
    letter-spacing: 0.12em;
    background: rgba(59, 130, 246, 0.12);
}
.team-card__body {
    padding: 18px 20px 22px;
    display: grid;
    gap: 6px;
    flex: 1;
}
.team-card__name {
    font-size: clamp(16px, 1.8vw, 20px);
    font-weight: 600;
    color: var(--brand-dark);
    margin-bottom: 0;
}
.team-card__name a {
    color: inherit;
    text-decoration: none;
}
.team-card__name a:hover {
    color: var(--brand-primary);
}
.team-card__meta,
.team-card__meta span {
    font-size: clamp(0.85rem, 1vw, 0.95rem);
    color: var(--text-muted);
}
.team-card__meta span + span::before {
    content: "•";
    margin: 0 6px;
    color: rgba(148, 163, 184, 0.85);
}
.team-card__footer {
    margin-top: 8px;
    font-size: 13px;
    color: rgba(100, 116, 139, 0.9);
}
.empty-state {
    padding: 24px;
    background: rgba(59, 130, 246, 0.08);
    border: 1px dashed rgba(59, 130, 246, 0.36);
    border-radius: 20px;
    color: var(--brand-primary);
    font-weight: 500;
}
.about-cta {
    background: var(--surface-foreground);
    border-radius: 26px;
    padding: clamp(24px, 5vw, 34px);
    box-shadow: 0 26px 48px rgba(15, 23, 42, 0.12);
    border: 1px solid rgba(148, 163, 184, 0.16);
    display: grid;
    gap: 16px;
    text-align: center;
    margin-top: 2.5rem;
    margin-bottom: 4rem;
}
.about-cta h3 {
    font-size: clamp(20px, 2.5vw, 30px);
    font-weight: 700;
    color: var(--brand-dark);
    margin-bottom: 0;
}
.about-cta p {
    margin-bottom: 0;
    color: var(--text-muted);
    font-size: clamp(1rem, 1.1vw, 1.15rem);
    line-height: 1.7;
}
.about-cta .btn {
    justify-self: center;
    padding: 10px 28px;
    border-radius: 999px;
    font-weight: 600;
    box-shadow: 0 18px 32px rgba(37, 99, 235, 0.25);
}
@media (max-width: 992px) {
    .about-hero--split {
        grid-template-columns: 1fr;
        min-height: auto;
    }
    .about-hero__visual {
        min-height: 300px;
    }
    .about-hero__visual::after {
        background: linear-gradient(180deg, rgba(11, 17, 30, 0.15) 0%, rgba(11, 17, 30, 0.85) 100%);
    }
    .about-hero__content {
        padding: clamp(32px, 5vw, 48px);
    }
    .about-hero__cta {
        justify-content: flex-start;
    }
    .division-group__header {
        flex-direction: column;
        align-items: flex-start;
    }
    .metric-card {
        padding: clamp(20px, 3vw, 28px);
    }
}
@media (max-width: 768px) {
    .about-hero__content {
        padding: clamp(28px, 4vw, 40px) !important;
    }
    .about-hero__title {
        font-size: clamp(24px, 6vw, 32px) !important;
    }
    .about-hero__lead {
        font-size: clamp(0.95rem, 1.1vw, 1.1rem) !important;
    }
    .metric-card {
        padding: clamp(18px, 3vw, 24px) !important;
    }
    .story-card,
    .values-card {
        padding: clamp(20px, 3vw, 28px) !important;
    }
}

@media (max-width: 576px) {
    .page-about > .container {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    .about-hero {
        border-radius: 24px;
        margin-bottom: 2rem;
    }
    .about-hero__visual {
        min-height: 240px;
    }
    .about-hero__content {
        padding: 28px 20px 36px !important;
        gap: 1.1rem;
    }
    .about-hero__brand img,
    .about-hero__brand .about-hero__brand-initials {
        width: 48px !important;
        height: 48px !important;
    }
    .about-hero__brand span {
        font-size: 0.9rem !important;
    }
    .about-hero__title {
        font-size: 22px !important;
        line-height: 1.3;
    }
    .about-hero__lead {
        font-size: 0.95rem !important;
        line-height: 1.65;
    }
    .metric-card {
        padding: 18px !important;
    }
    .metric-card__value {
        font-size: 28px !important;
    }
    .timeline__item {
        padding-left: 56px;
    }
    .timeline__item::before {
        left: 14px;
        width: 28px;
        height: 28px;
    }
    .about-hero__cta {
        flex-direction: column;
        align-items: stretch;
        gap: 0.75rem;
    }
    .btn-pill {
        width: 100%;
        justify-content: center;
        padding: 0.6rem 1.4rem;
        font-size: 0.95rem;
    }
    .team-card__body {
        padding: 16px 18px 20px;
    }
    .about-cta {
        padding: 24px 20px !important;
        margin-top: 2rem;
        margin-bottom: 3rem;
    }
    .about-cta h3 {
        font-size: 20px !important;
    }
}

/* ============================================
   ANIMASI SMOOTH UNTUK HALAMAN ABOUT
   ============================================ */

@keyframes aboutHeroFadeIn {
    from {
        opacity: 0;
        transform: translateY(40px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes aboutHeroSlideIn {
    from {
        opacity: 0;
        transform: translateX(-50px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

@keyframes aboutCardFloat {
    0%, 100% {
        transform: translateY(0);
    }
    50% {
        transform: translateY(-8px);
    }
}

@keyframes aboutImageZoom {
    from {
        opacity: 0;
        transform: scale(1.1);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}

@keyframes aboutMetricPulse {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.05);
    }
}

@keyframes aboutTimelineDraw {
    from {
        height: 0;
        opacity: 0;
    }
    to {
        height: 100%;
        opacity: 1;
    }
}

@keyframes aboutTeamCardSlide {
    from {
        opacity: 0;
        transform: translateY(30px) scale(0.95);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

/* About Hero Animations */
.about-hero {
    animation: aboutHeroFadeIn 0.8s ease-out;
}

.about-hero__visual {
    animation: aboutImageZoom 1s ease-out 0.3s both;
}

.about-hero__visual img {
    transition: transform 0.6s cubic-bezier(0.4, 0, 0.2, 1), filter 0.6s ease;
}

.about-hero:hover .about-hero__visual img {
    transform: scale(1.05);
    filter: brightness(1.1);
}

.about-hero__content {
    animation: aboutHeroSlideIn 0.8s ease-out 0.2s both;
}

.about-hero__brand {
    animation: fadeInDown 0.6s ease-out 0.4s both;
}

.about-hero__eyebrow {
    animation: fadeInLeft 0.6s ease-out 0.5s both;
}

.about-hero__title {
    animation: fadeInUp 0.8s ease-out 0.6s both;
}

.about-hero__lead {
    animation: fadeInUp 0.8s ease-out 0.7s both;
}

.about-hero__chips {
    animation: fadeInUp 0.6s ease-out 0.8s both;
}

.about-hero__chip {
    transition: transform 0.3s ease, background 0.3s ease;
    animation: scaleIn 0.4s ease-out both;
}

.about-hero__chip:nth-child(1) { animation-delay: 0.9s; }
.about-hero__chip:nth-child(2) { animation-delay: 1s; }
.about-hero__chip:nth-child(3) { animation-delay: 1.1s; }

.about-hero__chip:hover {
    transform: translateY(-2px) scale(1.05);
}

.about-hero__cta {
    animation: fadeInUp 0.6s ease-out 1s both;
}

/* Metric Cards Animations */
.metric-card {
    animation: aboutCardFloat 3s ease-in-out infinite;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.metric-card:nth-child(1) {
    animation-delay: 0s;
}

.metric-card:nth-child(2) {
    animation-delay: 0.5s;
}

.metric-card:nth-child(3) {
    animation-delay: 1s;
}

.metric-card:hover {
    animation-play-state: paused;
    transform: translateY(-10px) scale(1.03);
    box-shadow: 0 28px 48px rgba(15, 23, 42, 0.18);
}

.metric-card__value {
    animation: aboutMetricPulse 2s ease-in-out infinite;
    transition: transform 0.3s ease, color 0.3s ease;
}

.metric-card:hover .metric-card__value {
    transform: scale(1.1);
    color: var(--brand-secondary);
}

/* Story & Values Cards */
.story-card,
.values-card {
    animation: fadeInUp 0.6s ease-out both;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.story-card {
    animation-delay: 0.2s;
}

.values-card {
    animation-delay: 0.3s;
}

.story-card:hover,
.values-card:hover {
    transform: translateY(-6px);
    box-shadow: 0 32px 56px rgba(15, 23, 42, 0.16);
}

.values-list li {
    animation: fadeInLeft 0.5s ease-out both;
    transition: transform 0.3s ease, border-color 0.3s ease;
}

.values-list li:nth-child(1) { animation-delay: 0.1s; }
.values-list li:nth-child(2) { animation-delay: 0.2s; }
.values-list li:nth-child(3) { animation-delay: 0.3s; }

.values-list li:hover {
    transform: translateX(8px);
    border-color: var(--brand-secondary);
}

/* Timeline Animations */
.timeline {
    position: relative;
}

.timeline::before {
    animation: aboutTimelineDraw 1s ease-out 0.5s both;
}

.timeline__item {
    animation: aboutTeamCardSlide 0.6s ease-out both;
    transition: transform 0.3s ease;
}

.timeline__item:nth-child(1) { animation-delay: 0.6s; }
.timeline__item:nth-child(2) { animation-delay: 0.7s; }
.timeline__item:nth-child(3) { animation-delay: 0.8s; }
.timeline__item:nth-child(4) { animation-delay: 0.9s; }

.timeline__item:hover {
    transform: translateX(8px);
}

.timeline__item::before {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.timeline__item:hover::before {
    transform: scale(1.2);
    box-shadow: 0 0 20px rgba(59, 130, 246, 0.5);
}

/* Team Cards Animations */
.team-card {
    animation: aboutTeamCardSlide 0.5s ease-out both;
    transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1), box-shadow 0.3s ease;
}

.team-card:hover {
    transform: translateY(-8px) scale(1.02);
    box-shadow: 0 28px 52px rgba(15, 23, 42, 0.2);
}

.team-card__media {
    overflow: hidden;
    border-radius: 16px;
}

.team-card__media img,
.team-card__placeholder {
    transition: transform 0.5s cubic-bezier(0.4, 0, 0.2, 1), filter 0.5s ease;
}

.team-card__media img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center center;
}

.team-card:hover .team-card__media img,
.team-card:hover .team-card__placeholder {
    transform: scale(1.05);
    filter: brightness(1.05);
}
.team-card:hover .team-card__media::before {
    opacity: 1;
}

.team-card__name {
    transition: color 0.3s ease;
}

.team-card:hover .team-card__name {
    color: var(--brand-primary);
}

/* Division Group Animations */
.division-group {
    animation: fadeInUp 0.6s ease-out both;
}

.division-group:nth-child(1) { animation-delay: 0.1s; }
.division-group:nth-child(2) { animation-delay: 0.2s; }
.division-group:nth-child(3) { animation-delay: 0.3s; }
.division-group:nth-child(4) { animation-delay: 0.4s; }
.division-group:nth-child(5) { animation-delay: 0.5s; }

.division-group__header {
    animation: fadeInLeft 0.5s ease-out;
}

/* About CTA Animations */
.about-cta {
    animation: fadeInUp 0.8s ease-out;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.about-cta:hover {
    transform: translateY(-4px);
    box-shadow: 0 32px 64px rgba(15, 23, 42, 0.18);
}

.btn-pill {
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
    overflow: hidden;
}

.btn-pill::before {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 0;
    height: 0;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.3);
    transform: translate(-50%, -50%);
    transition: width 0.6s ease, height 0.6s ease;
}

.btn-pill:hover::before {
    width: 300px;
    height: 300px;
}

.btn-pill:hover {
    transform: translateY(-2px) scale(1.02);
}

.btn-pill:active {
    transform: translateY(0) scale(0.98);
}

/* Stagger Animation untuk Grid Items */
.team-card {
    opacity: 0;
    animation: aboutTeamCardSlide 0.5s ease-out forwards;
}

/* Reduce Motion */
@media (prefers-reduced-motion: reduce) {
    .about-hero,
    .metric-card,
    .team-card,
    .timeline__item,
    .story-card,
    .values-card {
        animation: none !important;
    }
    
    .metric-card {
        animation: none !important;
    }
}
</style>
<div class="page-about">
    <div class="container py-4">
        <section class="about-hero about-hero--split">
            <div class="about-hero__visual">
                <?php if ($bannerAsset['exists']): ?>
                    <img src="<?= esc($bannerAsset['url']) ?>" alt="Banner <?= esc($companyName) ?>">
                <?php else: ?>
                    <div class="about-hero__visual-fallback"></div>
                <?php endif; ?>
            </div>
            <div class="about-hero__content">
                <div class="about-hero__brand">
                    <?php if ($logoAsset['exists']): ?>
                        <img src="<?= esc($logoAsset['url']) ?>" alt="Logo <?= esc($companyName) ?>">
                    <?php else: ?>
                        <div class="about-hero__brand-initials"><?= esc($companyInitials) ?></div>
                    <?php endif; ?>
                    <span><?= esc($companyName) ?></span>
                </div>
                <span class="about-hero__eyebrow">Sekilas Tentang Saya</span>
                <h1 class="about-hero__title">Saya Dimas, web developer yang fokus pada produk digital yang stabil, terukur, dan nyaman digunakan.</h1>
                <p class="about-hero__lead">Saya membangun aplikasi end-to-end: menyusun arsitektur yang jelas, menulis API bersih, serta memastikan antarmuka responsif. Setiap rilis diupayakan cepat, terdokumentasi, dan mudah dipelihara.</p>
                <p class="about-hero__lead">Tech stack utama: CodeIgniter 4, MySQL, dan integrasi UI modern. Saya terbiasa bekerja lintas peran, menjaga standar kode, dan beriterasi berdasarkan data serta umpan balik pengguna.</p>
                <div class="about-hero__chips">
                    <span class="about-hero__chip">Web Development</span>
                    <span class="about-hero__chip">Backend &amp; API</span>
                    <span class="about-hero__chip">CodeIgniter 4 · MySQL</span>
                </div>
                <div class="about-hero__cta">
                    <a class="btn-pill btn-pill--primary" href="<?= base_url('cv') ?>">Lihat CV</a>
                    <a class="btn-pill btn-pill--ghost" href="<?= base_url('aktivitas') ?>">Aktivitas Harian</a>
                </div>
            </div>
        </section>

        <section class="about-story row g-3 g-lg-4 align-items-stretch">
            <div class="col-12 col-lg-7">
                <article class="story-card">
                    <h2>Misi Saya</h2>
                    <p>Menyampaikan solusi digital yang relevan, mudah digunakan, dan siap dikembangkan lebih lanjut. Saya mengutamakan alur sederhana, kode yang terjaga, serta komunikasi yang terstruktur agar kebutuhan bisnis dan pengguna tercapai.</p>
                </article>
            </div>
            <div class="col-12 col-lg-5">
                <aside class="values-card">
                    <h3>Nilai Kerja</h3>
                    <ul class="values-list">
                        <?php foreach ($coreValues as $value): ?>
                            <li>
                                <strong><?= esc($value['title']) ?></strong>
                                <span><?= esc($value['desc']) ?></span>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </aside>
            </div>
        </section>


        <section id="struktur" class="about-structure">
            <div class="section-heading">
                <span class="section-heading__label">
                    <span class="tag-chip tag-chip--success">Struktur</span>
                </span>
                <h3 class="section-heading__title">Kolaborasi &amp; Aktivitas</h3>
                <p class="section-heading__lead">Ringkasan aktivitas dan kolaborasi yang pernah dikerjakan. Gunakan filter per peran atau kategori untuk melihat detailnya.</p>
            </div>

            <form class="pegawai-filter mb-4" method="get" action="<?= base_url('about') ?>#struktur">
                    <div class="pegawai-filter__inner">
                        <div class="pegawai-filter__header">
                            <div class="d-flex align-items-center gap-2 flex-wrap">
                                <span class="pegawai-filter__eyebrow">Penyaring Data</span>
                                <span class="badge bg-primary-subtle text-primary border border-primary-subtle">
                                    <?= esc($activeFilterCount) ?> aktif
                                </span>
                            </div>
                            <div class="pegawai-filter__summary">
                                Menampilkan <?= esc($pegawaiCount) ?> pegawai
                            </div>
                        </div>
                    <div class="row gy-3 gx-4 align-items-end">
                        <div class="col-12 col-lg-5">
                            <label for="filterSearchPublic" class="form-label">Cari Pegawai</label>
                            <div class="input-group">
                                <span class="input-group-text bg-white border-end-0"><span style="color:#2563eb;">🔍</span></span>
                                <input
                                    type="search"
                                    class="form-control border-start-0"
                                    id="filterSearchPublic"
                                    name="q"
                                    placeholder="Cari nama pegawai"
                                    value="<?= esc($filters['search']) ?>">
                            </div>
                        </div>
                        <div class="col-6 col-lg-3">
                            <label for="filterDivisiPublic" class="form-label">Divisi</label>
                            <select class="form-select" id="filterDivisiPublic" name="divisi">
                                <option value="semua" <?= $filters['divisi'] === 'semua' ? 'selected' : '' ?>>Semua Divisi</option>
                                <?php foreach ($divisiList as $divisi): ?>
                                    <option value="<?= esc($divisi) ?>" <?= $filters['divisi'] === $divisi ? 'selected' : '' ?>>
                                        <?= esc($divisiLabels[$divisi] ?? $divisi) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-6 col-lg-2">
                            <label for="filterGenderPublic" class="form-label">Jenis Kelamin</label>
                            <select class="form-select" id="filterGenderPublic" name="jenis_kelamin">
                                <option value="semua" <?= $filters['jenis_kelamin'] === 'semua' ? 'selected' : '' ?>>Semua</option>
                                <option value="laki-laki" <?= $filters['jenis_kelamin'] === 'laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                                <option value="perempuan" <?= $filters['jenis_kelamin'] === 'perempuan' ? 'selected' : '' ?>>Perempuan</option>
                            </select>
                        </div>
                        <div class="col-12 col-lg-3 d-flex justify-content-lg-end mt-lg-1">
                            <div class="filter-actions w-100">
                                <button type="submit" class="btn btn-pill-primary btn-responsive">Terapkan</button>
                                <a class="btn btn-pill-ghost btn-responsive--ghost" href="<?= base_url('about') ?>#struktur">Reset</a>
                            </div>
                        </div>
                    </div>

                    <?php if ($hasFilters): ?>
                        <div class="mt-3 d-flex flex-wrap gap-2">
                            <?php if ($filters['search'] !== ''): ?>
                                <span class="filter-chip">
                                    <span class="filter-chip__label">Kata kunci</span>
                                    <span class="filter-chip__value"><?= esc($filters['search']) ?></span>
                                </span>
                            <?php endif; ?>
                            <?php if ($filters['divisi'] !== 'semua'): ?>
                                <span class="filter-chip">
                                    <span class="filter-chip__label">Divisi</span>
                                    <span class="filter-chip__value"><?= esc($divisiLabels[$filters['divisi']] ?? $filters['divisi']) ?></span>
                                </span>
                            <?php endif; ?>
                            <?php if ($filters['jenis_kelamin'] !== 'semua'): ?>
                                <span class="filter-chip">
                                    <span class="filter-chip__label">Jenis Kelamin</span>
                                    <span class="filter-chip__value"><?= esc(ucwords(str_replace('-', ' ', $filters['jenis_kelamin']))) ?></span>
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </form>

            <?php if (empty($pegawai)): ?>
                <div class="empty-state">
                    <?php if ($hasFilters): ?>
                        Tidak ditemukan pegawai sesuai filter. Coba ubah kata kunci atau reset filter.
                    <?php else: ?>
                        Belum ada data pegawai yang dapat ditampilkan. Silakan lengkapi melalui dashboard admin.
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <?php foreach ($divisiList as $divisi): ?>
                    <?php $items = $groupedPegawai[$divisi] ?? []; ?>
                    <div class="division-group">
                        <div class="division-group__header">
                            <h4 class="division-group__title"><?= esc($divisiLabels[$divisi] ?? $divisi) ?></h4>
                            <p class="division-group__info"><?= esc(count($items)) ?> anggota aktif</p>
                        </div>

                        <?php if (empty($items)): ?>
                            <div class="empty-state">Data divisi <?= esc($divisi) ?> belum tersedia.</div>
                        <?php else: ?>
                            <div class="row g-4 g-lg-5">
                                <?php foreach ($items as $pegawaiItem): ?>
                                    <?php
                                        $foto    = $resolvePhoto($pegawaiItem['foto_pegawai'] ?? '');
                                        $initial = $makeInitials($pegawaiItem['nama_pegawai'] ?? '', 2);
                                        $gender  = $pegawaiItem['jenis_kelamin'] ?? '';
                                        $birth   = $pegawaiItem['tanggal_lahir'] ?? '';
                                        $detailUrl = base_url('pegawai/'.$pegawaiItem['id_pegawai']);
                                        $genderLabel = $gender !== '' ? ucwords(strtolower($gender)) : 'Belum diisi';
                                        if ($birth !== '') {
                                            $birthLabel = date('d M Y', strtotime($birth));
                                        } else {
                                            $birthLabel = 'Belum diisi';
                                        }
                                    ?>
                                    <div class="col-12 col-sm-6 col-lg-4 col-xl-3 mb-3 mb-lg-4">
                                        <article class="team-card">
                                            <div class="team-card__media">
                                                <a href="<?= esc($detailUrl) ?>" aria-label="Detail <?= esc($pegawaiItem['nama_pegawai']) ?>">
                                                    <?php if ($foto['exists']): ?>
                                                        <img src="<?= esc($foto['url']) ?>" alt="Foto <?= esc($pegawaiItem['nama_pegawai']) ?>">
                                                    <?php else: ?>
                                                        <div class="team-card__placeholder"><?= esc($initial) ?></div>
                                                    <?php endif; ?>
                                                </a>
                                            </div>
                                            <div class="team-card__body">
                                                <h5 class="team-card__name">
                                                    <a href="<?= esc($detailUrl) ?>"><?= esc($pegawaiItem['nama_pegawai']) ?></a>
                                                </h5>
                                                <div class="team-card__meta">
                                                    <span><?= esc($genderLabel) ?></span>
                                                </div>
                                                <div class="team-card__footer">Tanggal lahir: <?= esc($birthLabel) ?></div>
                                            </div>
                                        </article>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </section>

        <section class="about-cta">
            <h3>Ingin berkolaborasi?</h3>
            <p>Hubungi saya untuk berdiskusi singkat seputar pengembangan web, integrasi API, atau perbaikan pengalaman pengguna.</p>
            <a class="btn btn-primary px-4" href="<?= base_url('contact') ?>">Kontak Saya</a>
        </section>
    </div>
</div>
<?= $this->endSection() ?>
