<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $filters = isset($filters) && is_array($filters) ? $filters : [];
    $filters = array_merge([
        'search' => '',
        'media'  => 'semua',
        'date'   => '',
        'sort'   => 'date_desc',
    ], $filters);
?>

<div class="container app-container py-4">
    <div class="row g-4">

<div class="col-12">
    <div class="page-loading-shell">
        <div class="page-loading-shell__skeleton" aria-hidden="true">
            <div class="row g-4">
                <?php for ($i = 0; $i < 3; $i++): ?>
                    <div class="col-12 col-md-6 col-xl-4">
                        <div class="card h-100 border-0" style="background: rgba(255,255,255,0.04);">
                            <div class="skeleton" style="height: 180px; border-radius: 18px 18px 0 0;"></div>
                            <div class="card-body">
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    <div class="skeleton skeleton-pill" style="width: 80px;"></div>
                                    <div class="skeleton skeleton-pill" style="width: 60px;"></div>
                                </div>
                                <div class="skeleton-line skeleton-lg" style="width: 70%;"></div>
                                <div class="skeleton-line" style="width: 90%;"></div>
                                <div class="skeleton-line" style="width: 60%;"></div>
                            </div>
                        </div>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
        <div class="page-loading-shell__content" data-loading-links>
            <?php if (empty($activities)): ?>
                <div class="empty-state">Belum ada aktivitas dicatat.</div>
            <?php else: ?>
                <div class="row g-4">
                    <?php foreach ($activities as $activity): ?>
                        <?php
                            $date       = $activity['activity_date'] ?? null;
                            $time       = $activity['activity_time'] ?? null;
                            $mediaType  = $activity['media_type'] ?? 'none';
                            $mediaPath  = $activity['media_path'] ?? null;
                            $formattedDate = $date ? date('d M Y', strtotime($date)) : '-';
                            $formattedTime = $time ? date('H:i', strtotime($time)) : 'Waktu tidak tercatat';
                            $description   = strip_tags((string) ($activity['description'] ?? ''));
                            $excerpt       = strlen($description) > 160 ? substr($description, 0, 160) . '...' : $description;
                        ?>
                        <div class="col-12 col-md-6 col-xl-4">
                            <article class="card h-100 shadow-sm border-0">
                                <?php if ($mediaType !== 'none' && $mediaPath): ?>
                                    <div class="embed-responsive embed-responsive-16by9 bg-light">
                                        <?php if ($mediaType === 'video'): ?>
                                            <video class="embed-responsive-item" controls preload="metadata">
                                                <source src="<?= esc(base_url($mediaPath)) ?>" type="video/mp4">
                                                Browser Anda tidak mendukung pemutar video.
                                            </video>
                                        <?php else: ?>
                                            <img src="<?= esc(base_url($mediaPath)) ?>" alt="<?= esc($activity['title'] ?? 'Media aktivitas') ?>" class="embed-responsive-item" style="object-fit: cover;">
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <div class="card-body d-flex flex-column">
                                    <div class="d-flex align-items-center flex-wrap mb-2" style="gap: .5rem;">
                                        <span class="badge badge-primary"><?= esc($formattedDate) ?></span>
                                        <span class="badge badge-light text-muted border"><?= esc($formattedTime) ?></span>
                                        <?php if (! empty($activity['location'])): ?>
                                            <span class="badge badge-dark"><?= esc($activity['location']) ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <h3 class="h5 mb-2"><?= esc($activity['title'] ?? 'Aktivitas') ?></h3>
                                    <p class="text-muted flex-grow-1 mb-3"><?= esc($excerpt) ?></p>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <span class="small text-muted">Media: <?= esc($mediaType === 'none' ? 'Tidak ada' : ucfirst($mediaType)) ?></span>
                                        <a href="<?= base_url('admin/aktivitas/' . ($activity['id'] ?? 0) . '/edit') ?>" class="btn btn-link p-0">Detail</a>
                                    </div>
                                </div>
                            </article>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="mt-4">
                    <?= $pager->links('activities', 'default_full') ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
