<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $this->setVar('pageTitle', 'Tambah Pegawai');
    $validation = $validation ?? null;
    $oldInput   = $oldInput ?? [];
?>

<div class="admin-card">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1">Tambah Pegawai Baru</h2>
            <p class="text-muted mb-0 small">Lengkapi data pegawai perusahaan beserta foto profil.</p>
        </div>
        <a href="<?= base_url('admin/perusahaan') ?>" class="btn btn-admin btn-admin-outline">
            ← Kembali
        </a>
    </div>
    <div class="admin-card__body">
        <form action="" method="post" class="needs-validation" enctype="multipart/form-data" novalidate>
            <?= csrf_field() ?>

            <div class="mb-3">
                <label for="nama_pegawai" class="form-label">Nama Pegawai</label>
                <input
                    type="text"
                    name="nama_pegawai"
                    id="nama_pegawai"
                    class="form-control <?= $validation && $validation->hasError('nama_pegawai') ? 'is-invalid' : '' ?>"
                    placeholder="Nama lengkap"
                    value="<?= esc($oldInput['nama_pegawai'] ?? '') ?>"
                    required>
                <?php if ($validation && $validation->hasError('nama_pegawai')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('nama_pegawai')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                <input
                    type="date"
                    name="tanggal_lahir"
                    id="tanggal_lahir"
                    class="form-control <?= $validation && $validation->hasError('tanggal_lahir') ? 'is-invalid' : '' ?>"
                    value="<?= esc($oldInput['tanggal_lahir'] ?? '') ?>"
                    required>
                <?php if ($validation && $validation->hasError('tanggal_lahir')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('tanggal_lahir')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                <select
                    name="jenis_kelamin"
                    id="jenis_kelamin"
                    class="form-select <?= $validation && $validation->hasError('jenis_kelamin') ? 'is-invalid' : '' ?>"
                    required>
                    <?php
                        $selectedGender = $oldInput['jenis_kelamin'] ?? 'laki-laki';
                    ?>
                    <option value="laki-laki" <?= $selectedGender === 'laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="perempuan" <?= $selectedGender === 'perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
                <?php if ($validation && $validation->hasError('jenis_kelamin')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('jenis_kelamin')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="divisi" class="form-label">Divisi</label>
                <?php $selectedDivisi = $oldInput['divisi'] ?? 'IT'; ?>
                <select
                    name="divisi"
                    id="divisi"
                    class="form-select <?= $validation && $validation->hasError('divisi') ? 'is-invalid' : '' ?>"
                    required>
                    <option value="Direktur Utama" <?= $selectedDivisi === 'Direktur Utama' ? 'selected' : '' ?>>Direktur Utama</option>
                    <option value="IT" <?= $selectedDivisi === 'IT' ? 'selected' : '' ?>>IT (Information Tecnology)</option>
                    <option value="Produksi" <?= $selectedDivisi === 'Produksi' ? 'selected' : '' ?>>Produksi</option>
                    <option value="Marketing" <?= $selectedDivisi === 'Marketing' ? 'selected' : '' ?>>Marketing</option>
                    <option value="HR" <?= $selectedDivisi === 'HR' ? 'selected' : '' ?>>HR (Human Resource)</option>
                </select>
                <?php if ($validation && $validation->hasError('divisi')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('divisi')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="foto_pegawai" class="form-label">Foto Pegawai (opsional)</label>
                <input
                    type="file"
                    name="foto_pegawai"
                    id="foto_pegawai"
                    accept=".jpg,.jpeg,.png,.webp"
                    class="form-control <?= $validation && $validation->hasError('foto_pegawai') ? 'is-invalid' : '' ?>">
                <?php if ($validation && $validation->hasError('foto_pegawai')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('foto_pegawai')) ?></div>
                <?php else: ?>
                    <div class="form-text text-muted">Format: JPG, PNG, atau WEBP maksimum 2 MB.</div>
                <?php endif; ?>
            </div>

            <div class="admin-card__footer">
                <div class="d-flex gap-2 justify-content-end">
                    <a href="<?= base_url('admin/perusahaan') ?>" class="btn btn-admin btn-admin-outline">Batal</a>
                    <button type="submit" class="btn btn-admin btn-admin-primary">
                        💾 Simpan Data
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
