<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $validation = $validation ?? null;
    $oldInput   = $oldInput ?? [];
    $errors     = session()->getFlashdata('errors') ?? [];
    $message    = session()->getFlashdata('message');
    $imageColumnAvailable = $imageColumnAvailable ?? false;
?>

<div class="mb-4">
    <h1 class="h4 mb-1">Edit Berita</h1>
    <p class="text-muted mb-0">Perbarui judul, isi, atau status berita.</p>
    <a href="<?= base_url('admin/news') ?>" class="btn btn-link ps-0">&larr; Kembali ke daftar</a>
</div>

<?php if ($message): ?>
    <div class="alert alert-success" role="alert">
        <?= esc($message) ?>
    </div>
<?php endif; ?>

<?php if (! empty($errors)): ?>
    <div class="alert alert-danger" role="alert">
        <?php foreach ($errors as $msg): ?>
            <div><?= esc($msg) ?></div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<div class="card shadow-sm">
    <div class="card-body">
        <form action="" method="post" class="needs-validation" enctype="multipart/form-data" novalidate>
            <?= csrf_field() ?>
            <input type="hidden" name="id" value="<?= esc($news['id']) ?>" />
            <input type="hidden" name="status" id="status-field" value="<?= esc($oldInput['status'] ?? $news['status']) ?>" />
            <div class="mb-3">
                <label for="title" class="form-label">Judul</label>
                <input
                    type="text"
                    name="title"
                    id="title"
                    class="form-control <?= $validation && $validation->hasError('title') ? 'is-invalid' : '' ?>"
                    placeholder="Judul berita"
                    value="<?= esc($oldInput['title'] ?? $news['title']) ?>"
                    required>
                <?php if ($validation && $validation->hasError('title')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('title')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="content" class="form-label">Isi Berita</label>
                <textarea
                    name="content"
                    id="content"
                    class="form-control <?= $validation && $validation->hasError('content') ? 'is-invalid' : '' ?>"
                    rows="8"
                    placeholder="Perbarui konten berita"
                    required><?= esc($oldInput['content'] ?? $news['content']) ?></textarea>
                <?php if ($validation && $validation->hasError('content')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('content')) ?></div>
                <?php endif; ?>
            </div>

            <?php if ($imageColumnAvailable): ?>
                <?php
                    $currentImage = $news['image_path'] ?? null;
                    $removeImageChecked = ! empty($oldInput['remove_image']);
                ?>
                <?php if ($currentImage): ?>
                    <div class="mb-3">
                        <label class="form-label">Gambar Saat Ini</label>
                        <div class="d-flex flex-wrap align-items-center gap-3">
                            <img
                                src="<?= base_url($currentImage) ?>"
                                alt="Gambar berita"
                                class="rounded border"
                                style="max-width: 180px; height: auto;">
                            <div class="form-check">
                                <input
                                    class="form-check-input"
                                    type="checkbox"
                                    name="remove_image"
                                    id="remove_image"
                                    value="1"
                                    <?= $removeImageChecked ? 'checked' : '' ?>>
                                <label class="form-check-label" for="remove_image">Hapus gambar ini</label>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="mb-3">
                    <label for="image" class="form-label"><?= $currentImage ? 'Ganti Gambar' : 'Gambar Berita (opsional)' ?></label>
                    <input
                        type="file"
                        name="image"
                        id="image"
                        accept=".jpg,.jpeg,.png,.webp"
                        class="form-control <?= $validation && $validation->hasError('image') ? 'is-invalid' : '' ?>">
                    <?php if ($validation && $validation->hasError('image')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('image')) ?></div>
                    <?php else: ?>
                        <div class="form-text text-muted">Format: JPG, PNG, atau WEBP maksimum 2 MB.</div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-warning" role="alert">
                    Kolom <code>image_path</code> belum tersedia di tabel <code>news</code>, sehingga unggah gambar tidak aktif.
                    Tambahkan kolom dengan perintah:
                    <code>ALTER TABLE news ADD image_path VARCHAR(255) NULL AFTER content;</code>
                </div>
            <?php endif; ?>

            <div class="d-flex flex-wrap align-items-center gap-2">
                <button type="submit" name="action" value="published" class="btn btn-primary" data-set-status="published">Terbitkan</button>
                <button type="submit" name="action" value="draft" class="btn btn-outline-secondary" data-set-status="draft">Simpan sebagai Draft</button>
                <span class="badge bg-light text-secondary ms-auto">
                    Status saat ini: <?= esc(ucfirst($oldInput['status'] ?? $news['status'])) ?>
                </span>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    const statusField = document.getElementById('status-field');
    if (!statusField) {
        return;
    }

    document.querySelectorAll('[data-set-status]').forEach((button) => {
        button.addEventListener('click', () => {
            statusField.value = button.getAttribute('data-set-status');
        });
    });
});
</script>

<?= $this->endSection() ?>
