<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $this->setVar('pageTitle', 'Edit Pegawai');
    $validation = $validation ?? null;
    $oldInput   = $oldInput ?? [];
    $dataPegawai = $pegawai ?? [];
    $currentName = $oldInput['nama_pegawai'] ?? ($dataPegawai['nama_pegawai'] ?? '');
    $currentDob = $oldInput['tanggal_lahir'] ?? ($dataPegawai['tanggal_lahir'] ?? '');
    $currentGender = $oldInput['jenis_kelamin'] ?? ($dataPegawai['jenis_kelamin'] ?? 'laki-laki');
    $currentDivisi = $oldInput['divisi'] ?? ($dataPegawai['divisi'] ?? 'IT');
?>

<div class="admin-card">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1">Edit Data Pegawai</h2>
            <p class="text-muted mb-0 small">Perbarui informasi pegawai atau ubah foto profil.</p>
        </div>
        <a href="<?= base_url('admin/perusahaan') ?>" class="btn btn-admin btn-admin-outline">
            ← Kembali
        </a>
    </div>
    <div class="admin-card__body">
        <form action="" method="post" class="needs-validation" enctype="multipart/form-data" novalidate>
            <?= csrf_field() ?>

            <div class="mb-3">
                <label for="nama_pegawai" class="form-label">Nama Pegawai</label>
                <input
                    type="text"
                    name="nama_pegawai"
                    id="nama_pegawai"
                    class="form-control <?= $validation && $validation->hasError('nama_pegawai') ? 'is-invalid' : '' ?>"
                    placeholder="Nama lengkap"
                    value="<?= esc($currentName) ?>"
                    required>
                <?php if ($validation && $validation->hasError('nama_pegawai')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('nama_pegawai')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="tanggal_lahir" class="form-label">Tanggal Lahir</label>
                <input
                    type="date"
                    name="tanggal_lahir"
                    id="tanggal_lahir"
                    class="form-control <?= $validation && $validation->hasError('tanggal_lahir') ? 'is-invalid' : '' ?>"
                    value="<?= esc($currentDob) ?>"
                    required>
                <?php if ($validation && $validation->hasError('tanggal_lahir')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('tanggal_lahir')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="jenis_kelamin" class="form-label">Jenis Kelamin</label>
                <select
                    name="jenis_kelamin"
                    id="jenis_kelamin"
                    class="form-select <?= $validation && $validation->hasError('jenis_kelamin') ? 'is-invalid' : '' ?>"
                    required>
                    <option value="laki-laki" <?= $currentGender === 'laki-laki' ? 'selected' : '' ?>>Laki-laki</option>
                    <option value="perempuan" <?= $currentGender === 'perempuan' ? 'selected' : '' ?>>Perempuan</option>
                </select>
                <?php if ($validation && $validation->hasError('jenis_kelamin')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('jenis_kelamin')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label for="divisi" class="form-label">Divisi</label>
                <select
                    name="divisi"
                    id="divisi"
                    class="form-select <?= $validation && $validation->hasError('divisi') ? 'is-invalid' : '' ?>"
                    required>
                    <option value="Direktur Utama" <?= $currentDivisi === 'Direktur Utama' ? 'selected' : '' ?>>Direktur Utama</option>
                    <option value="IT" <?= $currentDivisi === 'IT' ? 'selected' : '' ?>>IT (Information Tecnology)</option>
                    <option value="Produksi" <?= $currentDivisi === 'Produksi' ? 'selected' : '' ?>>Produksi</option>
                    <option value="Marketing" <?= $currentDivisi === 'Marketing' ? 'selected' : '' ?>>Marketing</option>
                    <option value="HR" <?= $currentDivisi === 'HR' ? 'selected' : '' ?>>HR (Human Resource)</option>
                </select>
                <?php if ($validation && $validation->hasError('divisi')): ?>
                    <div class="invalid-feedback"><?= esc($validation->getError('divisi')) ?></div>
                <?php endif; ?>
            </div>

            <div class="mb-3">
                <label class="form-label">Foto Pegawai</label>
                <div class="d-flex flex-column flex-md-row align-items-md-center gap-3">
                    <div class="border rounded p-2 bg-light">
                        <?php if (! empty($dataPegawai['foto_pegawai'])): ?>
                            <img
                                src="<?= base_url($dataPegawai['foto_pegawai']) ?>"
                                alt="Foto <?= esc($dataPegawai['nama_pegawai'] ?? '') ?>"
                                style="width: 120px; height: 120px; object-fit: cover;"
                                class="rounded">
                        <?php else: ?>
                            <div class="text-muted small">Belum ada foto</div>
                        <?php endif; ?>
                    </div>
                    <div class="flex-grow-1">
                        <input
                            type="file"
                            name="foto_pegawai"
                            id="foto_pegawai"
                            accept=".jpg,.jpeg,.png,.webp"
                            class="form-control <?= $validation && $validation->hasError('foto_pegawai') ? 'is-invalid' : '' ?>">
                        <?php if ($validation && $validation->hasError('foto_pegawai')): ?>
                            <div class="invalid-feedback"><?= esc($validation->getError('foto_pegawai')) ?></div>
                        <?php else: ?>
                            <div class="form-text text-muted">Biarkan kosong jika tidak ingin mengganti foto. Maksimum 2 MB.</div>
                        <?php endif; ?>

                        <?php if (! empty($dataPegawai['foto_pegawai'])): ?>
                            <div class="form-check mt-2">
                                <input class="form-check-input" type="checkbox" value="1" id="remove_photo" name="remove_photo">
                                <label class="form-check-label" for="remove_photo">
                                    Hapus foto saat ini
                                </label>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="admin-card__footer">
                <div class="d-flex gap-2 justify-content-end">
                    <a href="<?= base_url('admin/perusahaan') ?>" class="btn btn-admin btn-admin-outline">Batal</a>
                    <button type="submit" class="btn btn-admin btn-admin-primary">
                        💾 Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
