<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $mode       = $mode ?? 'create';
    $isEdit     = $mode === 'edit';
    $this->setVar('pageTitle', $isEdit ? 'Edit Pendidikan' : 'Tambah Pendidikan');
    $record     = $record ?? [];
    $validation = $validation ?? null;
    $oldInput   = $oldInput ?? [];
    $data       = array_merge($record, $oldInput);
    $degreeOptions = ['SD', 'SMP', 'SMA/SMK', 'Diploma', 'Sarjana', 'Magister', 'Doktor', 'Lainnya'];
?>

<div class="admin-card">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1"><?= $isEdit ? 'Edit Riwayat Pendidikan' : 'Tambah Riwayat Pendidikan' ?></h2>
            <p class="text-muted mb-0 small">Isi jenjang, institusi, jurusan, dan periode pendidikan.</p>
        </div>
        <a href="<?= base_url('admin/pendidikan') ?>" class="btn btn-admin btn-admin-outline">← Kembali</a>
    </div>
    <div class="admin-card__body">
        <form action="" method="post" class="needs-validation" novalidate>
            <?= csrf_field() ?>

            <div class="row g-3">
                <div class="col-md-6">
                    <label for="institution" class="form-label">Institusi</label>
                    <input
                        type="text"
                        name="institution"
                        id="institution"
                        class="form-control <?= $validation && $validation->hasError('institution') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['institution'] ?? '') ?>"
                        required>
                    <?php if ($validation && $validation->hasError('institution')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('institution')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <label for="degree" class="form-label">Jenjang</label>
                    <select
                        name="degree"
                        id="degree"
                        class="form-select <?= $validation && $validation->hasError('degree') ? 'is-invalid' : '' ?>"
                        required>
                        <?php
                            $selectedDegree = $data['degree'] ?? 'Sarjana';
                        ?>
                        <?php foreach ($degreeOptions as $option): ?>
                            <option value="<?= esc($option) ?>" <?= $selectedDegree === $option ? 'selected' : '' ?>><?= esc($option) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?php if ($validation && $validation->hasError('degree')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('degree')) ?></div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="row g-3 mt-1">
                <div class="col-md-6">
                    <label for="field_of_study" class="form-label">Jurusan / Program Studi</label>
                    <input
                        type="text"
                        name="field_of_study"
                        id="field_of_study"
                        class="form-control <?= $validation && $validation->hasError('field_of_study') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['field_of_study'] ?? '') ?>">
                    <?php if ($validation && $validation->hasError('field_of_study')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('field_of_study')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <label for="city" class="form-label">Kota</label>
                    <input
                        type="text"
                        name="city"
                        id="city"
                        class="form-control <?= $validation && $validation->hasError('city') ? 'is-invalid' : '' ?>"
                        value="<?= esc($data['city'] ?? '') ?>">
                    <?php if ($validation && $validation->hasError('city')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('city')) ?></div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="row g-3 mt-1">
                <div class="col-md-3">
                    <label for="start_year" class="form-label">Tahun Mulai</label>
                    <input
                        type="number"
                        name="start_year"
                        id="start_year"
                        class="form-control <?= $validation && $validation->hasError('start_year') ? 'is-invalid' : '' ?>"
                        min="1900"
                        max="2100"
                        value="<?= esc($data['start_year'] ?? '') ?>"
                        required>
                    <?php if ($validation && $validation->hasError('start_year')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('start_year')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-3">
                    <label for="end_year" class="form-label">Tahun Selesai (opsional)</label>
                    <input
                        type="number"
                        name="end_year"
                        id="end_year"
                        class="form-control <?= $validation && $validation->hasError('end_year') ? 'is-invalid' : '' ?>"
                        min="1900"
                        max="2100"
                        value="<?= esc($data['end_year'] ?? '') ?>">
                    <?php if ($validation && $validation->hasError('end_year')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('end_year')) ?></div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <label for="description" class="form-label">Deskripsi</label>
                    <textarea
                        name="description"
                        id="description"
                        rows="3"
                        class="form-control <?= $validation && $validation->hasError('description') ? 'is-invalid' : '' ?>"
                        placeholder="Catatan prestasi atau fokus studi"><?= esc($data['description'] ?? '') ?></textarea>
                    <?php if ($validation && $validation->hasError('description')): ?>
                        <div class="invalid-feedback"><?= esc($validation->getError('description')) ?></div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="admin-card__footer">
                <div class="d-flex gap-2 justify-content-end">
                    <a href="<?= base_url('admin/pendidikan') ?>" class="btn btn-admin btn-admin-outline">Batal</a>
                    <button type="submit" class="btn btn-admin btn-admin-primary">
                        <?= $isEdit ? 'Simpan Perubahan' : 'Simpan Pendidikan' ?>
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
