<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>
<?php
    $this->setVar('pageTitle', 'Riwayat Pendidikan');
    $filters = isset($filters) && is_array($filters) ? $filters : [];
    $filters = array_merge([
        'search'     => '',
        'degree'     => 'semua',
        'start_year' => '',
        'end_year'   => '',
        'sort'       => 'start_desc',
    ], $filters);
    $degreeOptions = $degreeOptions ?? [];
?>

<?php if ($message = session()->getFlashdata('message')): ?>
    <div class="alert alert-success alert-dismissible fade show mb-4" role="alert">
        <?= esc($message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Tutup"></button>
    </div>
<?php endif; ?>

<div class="admin-card mb-4">
    <div class="admin-card__header">
        <div>
            <h2 class="admin-card__title mb-1">Riwayat Pendidikan</h2>
            <p class="text-muted mb-0 small">Kelola riwayat pendidikan mulai dari sekolah dasar hingga perguruan tinggi.</p>
        </div>
        <a class="btn btn-admin btn-admin-primary" href="<?= base_url('admin/pendidikan/new') ?>">
            <span aria-hidden="true">+</span>
            <span>Tambah Pendidikan</span>
        </a>
    </div>

    <div class="admin-card__body">
        <form class="row g-3 align-items-end mb-4 js-loading-form" method="get" action="<?= base_url('admin/pendidikan') ?>">
            <div class="col-12 col-lg-4">
                <label for="filterSearchEdu" class="form-label">Pencarian</label>
                <div class="input-group">
                    <span class="input-group-text bg-white border-end-0"><span aria-hidden="true">🔍</span></span>
                    <input
                        type="search"
                        name="q"
                        id="filterSearchEdu"
                        class="form-control border-start-0"
                        placeholder="Cari institusi atau jurusan"
                        value="<?= esc($filters['search']) ?>">
                </div>
            </div>
            <div class="col-6 col-lg-2">
                <label for="filterDegree" class="form-label">Jenjang</label>
                <select class="form-select" name="degree" id="filterDegree">
                    <option value="semua" <?= $filters['degree'] === 'semua' ? 'selected' : '' ?>>Semua</option>
                    <?php foreach ($degreeOptions as $option): ?>
                        <option value="<?= esc($option) ?>" <?= $filters['degree'] === $option ? 'selected' : '' ?>>
                            <?= esc($option) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-6 col-lg-2">
                <label for="filterStartYear" class="form-label">Mulai ≥</label>
                <input
                    type="number"
                    name="start_year"
                    id="filterStartYear"
                    class="form-control"
                    min="1900"
                    max="2100"
                    value="<?= esc($filters['start_year']) ?>">
            </div>
            <div class="col-6 col-lg-2">
                <label for="filterEndYear" class="form-label">Selesai ≤</label>
                <input
                    type="number"
                    name="end_year"
                    id="filterEndYear"
                    class="form-control"
                    min="1900"
                    max="2100"
                    value="<?= esc($filters['end_year']) ?>">
            </div>
            <div class="col-6 col-lg-1">
                <label for="filterSortEdu" class="form-label">Urutkan</label>
                <select class="form-select" name="sort" id="filterSortEdu">
                    <option value="start_desc" <?= $filters['sort'] === 'start_desc' ? 'selected' : '' ?>>Tahun terbaru</option>
                    <option value="start_asc" <?= $filters['sort'] === 'start_asc' ? 'selected' : '' ?>>Tahun terlama</option>
                    <option value="degree" <?= $filters['sort'] === 'degree' ? 'selected' : '' ?>>Urut jenjang</option>
                </select>
            </div>
            <div class="col-6 col-lg-1">
                <button type="submit" class="btn btn-admin btn-admin-primary w-100">Terapkan</button>
            </div>
            <div class="col-6 col-lg-1">
                <a href="<?= base_url('admin/pendidikan') ?>" class="btn btn-admin btn-admin-outline w-100">Reset</a>
            </div>
        </form>

<div class="admin-loading-shell">
    <div class="admin-loading-shell__skeleton" aria-hidden="true">
        <div class="skeleton skeleton-pill mb-3" style="width: 200px;"></div>
        <?php for ($i = 0; $i < 4; $i++): ?>
            <div class="d-flex align-items-center mb-3" style="gap: 14px;">
                <div class="skeleton skeleton-pill" style="width: 120px;"></div>
                <div class="flex-fill">
                    <div class="skeleton-line skeleton-lg" style="width: 70%;"></div>
                    <div class="skeleton-line skeleton-sm" style="width: 42%;"></div>
                </div>
                <div class="d-none d-lg-block skeleton" style="width: 110px; height: 32px; border-radius: 10px;"></div>
            </div>
        <?php endfor; ?>
    </div>
    <div class="admin-loading-shell__content" data-loading-links>
        <?php if (empty($records)): ?>
            <div class="admin-empty">
                <div class="admin-empty__icon" aria-hidden="true">dYZ"</div>
                <div class="admin-empty__title">Belum ada data pendidikan</div>
                <div class="admin-empty__text">Tambahkan riwayat pendidikan untuk melihat daftar.</div>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="admin-table">
                    <thead>
                        <tr>
                            <th>Jenjang</th>
                            <th>Institusi</th>
                            <th>Jurusan</th>
                            <th>Kota</th>
                            <th>Periode</th>
                            <th class="text-end">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($records as $record): ?>
                            <?php
                                $start = $record['start_year'] ?? '';
                                $end   = $record['end_year'] ?? '';
                                $period = $start ? $start . ' - ' . ($end ?: 'Sekarang') : '-';
                            ?>
                            <tr>
                                <td><span class="admin-badge admin-badge--secondary"><?= esc($record['degree'] ?? '-') ?></span></td>
                                <td>
                                    <div class="fw-semibold text-dark"><?= esc($record['institution'] ?? '-') ?></div>
                                    <div class="text-muted small"><?= esc(isset($record['updated_at']) ? date('d M Y', strtotime($record['updated_at'])) : '-') ?></div>
                                </td>
                                <td><?= esc($record['field_of_study'] ?? '-') ?></td>
                                <td><?= esc($record['city'] ?? '-') ?></td>
                                <td><?= esc($period) ?></td>
                                <td class="text-end">
                                    <div class="d-flex justify-content-end gap-2">
                                        <a href="<?= base_url('admin/pendidikan/' . $record['id'] . '/edit') ?>" class="btn btn-sm btn-admin btn-admin-outline js-loading-link">Edit</a>
                                        <form action="<?= base_url('admin/pendidikan/' . $record['id'] . '/delete') ?>" method="post" class="d-inline" onsubmit="return confirm('Hapus riwayat pendidikan ini secara permanen?');">
                                            <?= csrf_field() ?>
                                            <button type="submit" class="btn btn-sm btn-admin btn-admin-danger">Hapus</button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-between align-items-center mt-3 flex-wrap" style="gap: .75rem;">
                <div class="text-muted small">Pagination 10 data per halaman.</div>
                <?= $pager->links('education', 'default_full') ?>
            </div>
        <?php endif; ?>
    </div>
</div>
    </div>
</div>

<?= $this->endSection() ?>
