<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $filters = isset($filters) && is_array($filters) ? $filters : [];
    $filters = array_merge([
        'search'   => '',
        'headline' => 'semua',
        'sort'     => 'newest',
    ], $filters);
    $headlineOptions = $headlineOptions ?? [];
?>

<div class="container app-container py-4">
    <div class="row g-4">
        <div class="col-12">
            <div class="d-flex flex-column flex-lg-row align-items-lg-center justify-content-between" style="gap: 1rem;">
                <div>
                    <p class="home-meta mb-1 text-uppercase">Profil Biodata / CV</p>
                    <h1 class="mb-0">Biodata & CV</h1>
                    <p class="text-muted mb-0">Kumpulan biodata lengkap: nama, alamat, kontak, skill, hingga ringkasan.</p>
                </div>
                <a href="<?= base_url('admin/biodata') ?>" class="btn btn-primary">Kelola di Admin</a>
            </div>
        </div>

        <div class="col-12">
            <div class="card-surface p-3 p-md-4 shadow-sm">
                <form class="row g-3 align-items-end">
                    <div class="col-12 col-lg-5">
                        <label for="searchProfile" class="form-label">Pencarian</label>
                        <input
                            type="search"
                            name="q"
                            id="searchProfile"
                            class="form-control"
                            placeholder="Cari nama, skill, atau headline"
                            value="<?= esc($filters['search']) ?>">
                    </div>
                    <div class="col-6 col-lg-3">
                        <label for="headlineFilter" class="form-label">Headline</label>
                        <select class="custom-select" name="headline" id="headlineFilter">
                            <option value="semua" <?= $filters['headline'] === 'semua' ? 'selected' : '' ?>>Semua Headline</option>
                            <?php foreach ($headlineOptions as $headline): ?>
                                <option value="<?= esc($headline) ?>" <?= $filters['headline'] === $headline ? 'selected' : '' ?>>
                                    <?= esc($headline) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-6 col-lg-2">
                        <label for="sortProfile" class="form-label">Urutkan</label>
                        <select class="custom-select" name="sort" id="sortProfile">
                            <option value="newest" <?= $filters['sort'] === 'newest' ? 'selected' : '' ?>>Terbaru</option>
                            <option value="name_asc" <?= $filters['sort'] === 'name_asc' ? 'selected' : '' ?>>Nama A-Z</option>
                            <option value="name_desc" <?= $filters['sort'] === 'name_desc' ? 'selected' : '' ?>>Nama Z-A</option>
                        </select>
                    </div>
                    <div class="col-6 col-lg-1">
                        <button type="submit" class="btn btn-primary btn-block">Terapkan</button>
                    </div>
                    <div class="col-6 col-lg-1">
                        <a href="<?= base_url('biodata') ?>" class="btn btn-outline-secondary btn-block">Reset</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-12">
            <?php if (empty($profiles)): ?>
                <div class="empty-state">Belum ada biodata tersimpan.</div>
            <?php else: ?>
                <div class="row g-4">
                    <?php foreach ($profiles as $profile): ?>
                        <?php
                            $skills = array_filter(array_map('trim', explode(',', (string) ($profile['skills'] ?? ''))));
                        ?>
                        <div class="col-12 col-md-6">
                            <div class="card h-100 shadow-sm border-0">
                                <div class="card-body d-flex">
                                    <div class="mr-3">
                                        <?php if (! empty($profile['photo_path'])): ?>
                                            <img src="<?= esc(base_url($profile['photo_path'])) ?>" alt="<?= esc($profile['full_name'] ?? 'Foto profil') ?>" class="rounded-circle" style="width: 64px; height: 64px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="rounded-circle bg-light d-flex align-items-center justify-content-center text-muted" style="width: 64px; height: 64px;">
                                                <?= esc(substr((string) ($profile['full_name'] ?? 'NF'), 0, 2)) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex-grow-1">
                                        <h3 class="h5 mb-1"><?= esc($profile['full_name'] ?? 'Tanpa Nama') ?></h3>
                                        <div class="text-muted mb-2"><?= esc($profile['headline'] ?? '') ?></div>
                                        <p class="mb-2 text-muted"><?= esc($profile['summary'] ?? '') ?></p>
                                        <?php if (! empty($skills)): ?>
                                            <div class="mb-2 d-flex flex-wrap" style="gap: .35rem;">
                                                <?php foreach ($skills as $skill): ?>
                                                    <span class="badge badge-secondary"><?= esc($skill) ?></span>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="small text-muted">
                                            <?php if (! empty($profile['address'])): ?>
                                                <div>Alamat: <?= esc($profile['address']) ?></div>
                                            <?php endif; ?>
                                            <?php if (! empty($profile['email'])): ?>
                                                <div>Email: <?= esc($profile['email']) ?></div>
                                            <?php endif; ?>
                                            <?php if (! empty($profile['phone'])): ?>
                                                <div>Telepon: <?= esc($profile['phone']) ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer d-flex justify-content-between align-items-center bg-white">
                                    <span class="small text-muted">Diperbarui: <?= esc(isset($profile['updated_at']) ? date('d M Y', strtotime($profile['updated_at'])) : '-') ?></span>
                                    <a href="<?= base_url('admin/biodata/' . ($profile['id'] ?? 0) . '/edit') ?>" class="btn btn-link p-0">Detail</a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="mt-4">
                    <?= $pager->links('biodata', 'default_full') ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
