<?= $this->extend('layout/page_layout') ?>

<?= $this->section('content') ?>
<?php
    $profile = $profile ?? [];
    $skills  = array_filter(array_map('trim', explode(',', (string) ($profile['skills'] ?? ''))));

    $photoUrl = '';
    if (! empty($profile['photo_path'])) {
        $relative = ltrim($profile['photo_path'], '/');
        $fullPath = FCPATH . $relative;
        if (is_file($fullPath)) {
            $photoUrl = base_url($relative) . '?v=' . filemtime($fullPath);
        }
    }
    // Fallback: gunakan foto profil bawaan pengguna jika tersedia di public/uploads/biodata/profile.jpg/png/webp
    if ($photoUrl === '') {
        foreach (['public/uploads/biodata/profile.jpg', 'public/uploads/biodata/profile.png', 'public/uploads/biodata/profile.webp'] as $candidate) {
            $full = FCPATH . ltrim(str_replace('public/', '', $candidate), '/');
            if (is_file($full)) {
                $relative = ltrim(str_replace('public/', '', $candidate), '/');
                $photoUrl = base_url($relative) . '?v=' . filemtime($full);
                break;
            }
        }
    }

    $contactItems = [
        'phone'   => trim((string) ($profile['phone'] ?? '')),
        'email'   => trim((string) ($profile['email'] ?? '')),
        'address' => trim((string) ($profile['address'] ?? '')),
    ];
    // Tampilkan placeholder bila field kosong agar kontak tetap terlihat.
    if ($contactItems['phone'] === '') {
        $contactItems['phone'] = 'Nomor belum diisi';
    }
    if ($contactItems['email'] === '') {
        $contactItems['email'] = 'Email belum diisi';
    }
    if ($contactItems['address'] === '') {
        $contactItems['address'] = 'Alamat belum diisi';
    }

    $experiences = [
        [
            'role'    => 'Full-Stack Web Developer (Freelance/Kampus)',
            'period'  => 'Jan 2024 - Sekarang',
            'place'   => 'Proyek portofolio dan tugas akhir',
            'bullets' => [
                'Membangun aplikasi portofolio dengan CodeIgniter 4, MySQL, dan Bootstrap.',
                'Merancang API CRUD biodata dan aktivitas harian dengan validasi, upload foto, dan pagination.',
                'Menerapkan autentikasi admin serta filter pencarian supaya pengelolaan konten lebih rapi.',
            ],
        ],
        [
            'role'    => 'Web Developer Magang',
            'period'  => 'Jul 2023 - Des 2023',
            'place'   => 'Studio web lokal',
            'bullets' => [
                'Mendukung pembuatan landing page dan dashboard sederhana menggunakan PHP dan JavaScript.',
                'Menulis query MySQL dasar, optimasi indeks ringan, serta uji coba form input yang aman.',
            ],
        ],
    ];

    $educations = [
        [
            'degree' => 'SMA',
            'school' => 'SMAN 12 Kabupaten Tangerang',
            'period' => '2018 - 2021',
        ],
        [
            'degree' => 'SMP',
            'school' => 'SMPN 1 Teluknaga',
            'period' => '2015 - 2018',
        ],
        [
            'degree' => 'SD',
            'school' => 'SDN Bojong Renged V',
            'period' => '2009 - 2015',
        ],
    ];
?>

<style>
.cv-layout {
    display: grid;
    grid-template-columns: 320px 1fr;
    gap: 1.5rem;
    background: #0f172a;
    border-radius: 26px;
    overflow: hidden;
    box-shadow: 0 30px 60px rgba(15, 23, 42, 0.25);
}
.cv-sidebar {
    background: linear-gradient(150deg, #0b1220, #0e7490);
    color: #e2e8f0;
    padding: 1.75rem 1.5rem;
    display: grid;
    gap: 1rem;
}
.cv-photo {
    width: 120px;
    height: 120px;
    border-radius: 18px;
    overflow: hidden;
    border: 4px solid rgba(255, 255, 255, 0.18);
    box-shadow: 0 16px 36px rgba(0, 0, 0, 0.25);
}
.cv-photo img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.cv-name {
    margin: 0.6rem 0 0.15rem;
    font-size: 1.35rem;
    font-weight: 700;
}
.cv-role {
    margin: 0;
    color: #cbd5e1;
    font-weight: 600;
}
.cv-section-title {
    font-size: 0.9rem;
    letter-spacing: 0.08em;
    text-transform: uppercase;
    color: #cbd5e1;
    margin-bottom: 0.4rem;
}
.cv-list {
    list-style: none;
    padding: 0;
    margin: 0;
    display: grid;
    gap: 0.35rem;
}
.cv-list li {
    display: flex;
    gap: 0.6rem;
    align-items: baseline;
    color: #e2e8f0;
    font-size: 0.95rem;
}
.cv-list li span {
    color: #cbd5e1;
}
.cv-list .label {
    color: #94a3b8;
    min-width: 62px;
    font-weight: 600;
}
.cv-tag {
    display: inline-flex;
    align-items: center;
    padding: 0.35rem 0.75rem;
    border-radius: 999px;
    background: rgba(255, 255, 255, 0.12);
    color: #e2e8f0;
    font-weight: 600;
    font-size: 0.9rem;
    margin: 0.2rem;
}
.cv-main {
    background: #ffffff;
    border-radius: 22px;
    margin: 1rem 1rem 1rem 0;
    padding: 2rem;
    display: grid;
    gap: 1.5rem;
    box-shadow: inset 0 1px 0 rgba(148, 163, 184, 0.16);
}
.cv-block h3 {
    margin: 0 0 0.4rem;
    font-size: 1.1rem;
}
.cv-block p {
    margin: 0.2rem 0;
    color: #4b5563;
}
.cv-block ul {
    margin: 0.35rem 0 0;
    padding-left: 1.2rem;
    color: #4b5563;
}
.cv-block ul li {
    margin-bottom: 0.25rem;
}
.cv-experience-item {
    margin-bottom: 1rem;
}
.cv-experience-meta {
    display: flex;
    justify-content: space-between;
    color: #6b7280;
    font-weight: 600;
}
.cv-education-item {
    margin-bottom: 0.8rem;
}
@media (max-width: 960px) {
    .cv-layout {
        grid-template-columns: 1fr;
    }
    .cv-main {
        margin: 0 1rem 1rem;
    }
}
</style>

<div class="container app-container py-4">
    <div class="cv-layout">
        <aside class="cv-sidebar">
            <div class="d-flex flex-column align-items-start">
                <div class="cv-photo">
                    <?php if ($photoUrl): ?>
                        <img src="<?= esc($photoUrl) ?>" alt="Foto <?= esc($profile['full_name'] ?? '') ?>">
                    <?php else: ?>
                        <img src="https://ui-avatars.com/api/?name=<?= urlencode($profile['full_name'] ?? 'Dimas Cahya Ramadhan') ?>&background=0e7490&color=fff&size=280" alt="Avatar">
                    <?php endif; ?>
                </div>
                <h2 class="cv-name"><?= esc($profile['full_name'] ?? 'Nama Lengkap') ?></h2>
                <p class="cv-role"><?= esc($profile['headline'] ?? 'Web Developer') ?></p>
            </div>

            <div>
                <div class="cv-section-title">Kontak</div>
                <ul class="cv-list">
                    <?php if ($contactItems['phone'] !== ''): ?>
                        <li><span class="label">Telp</span><span><?= esc($contactItems['phone']) ?></span></li>
                    <?php endif; ?>
                    <?php if ($contactItems['email'] !== ''): ?>
                        <li><span class="label">Email</span><span><?= esc($contactItems['email']) ?></span></li>
                    <?php endif; ?>
                    <?php if ($contactItems['address'] !== ''): ?>
                        <li><span class="label">Alamat</span><span><?= esc($contactItems['address']) ?></span></li>
                    <?php endif; ?>
                </ul>
            </div>

            <?php if (! empty($skills)): ?>
                <div>
                    <div class="cv-section-title">Skills</div>
                    <div>
                        <?php foreach ($skills as $skill): ?>
                            <span class="cv-tag"><?= esc($skill) ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
        </aside>

        <main class="cv-main">
            <div class="cv-block">
                <h3>Profil Singkat</h3>
                <p><?= esc($profile['summary'] ?? 'Lengkapi ringkasan profil untuk menampilkan deskripsi profesional.') ?></p>
            </div>

            <div class="cv-block">
                <h3>Pengalaman</h3>
                <?php foreach ($experiences as $exp): ?>
                    <div class="cv-experience-item">
                        <div class="cv-experience-meta">
                            <span><?= esc($exp['role']) ?></span>
                            <span><?= esc($exp['period']) ?></span>
                        </div>
                        <p class="text-muted mb-1"><?= esc($exp['place']) ?></p>
                        <?php if (! empty($exp['bullets'])): ?>
                            <ul>
                                <?php foreach ($exp['bullets'] as $item): ?>
                                    <li><?= esc($item) ?></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>

            <div class="cv-block">
                <h3>Pendidikan</h3>
                <?php foreach ($educations as $edu): ?>
                    <div class="cv-education-item">
                        <strong><?= esc($edu['degree']) ?></strong>
                        <div class="text-muted"><?= esc($edu['school']) ?> - <?= esc($edu['period']) ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
        </main>
    </div>
</div>

<?= $this->endSection() ?>
