<?php
    // Hilangkan penggunaan banner foto; pakai hero gradien saja.
    $bannerAsset = null;
?>
<header class="app-hero <?= $bannerAsset ? 'app-hero--with-media' : '' ?>">
    <div class="container">
        <div class="app-hero__grid">
            <div>
                <span class="app-hero__badge">Portofolio Pribadi</span>
                <h1 class="app-hero__title">Dimas Cahya Ramadhan · Web Developer</h1>
                <p class="app-hero__lead">
                    Ringkasan aktivitas harian, CV, dan riwayat pendidikan dalam satu halaman interaktif.
                    Jelajahi pengalaman, skill, serta dokumentasi progres yang terus diperbarui.
                </p>
                <div class="d-flex flex-wrap" style="gap: 0.75rem;">
                    <a class="app-hero__cta" href="<?= base_url('cv') ?>">
                        Lihat Biodata
                        <span aria-hidden="true">→</span>
                    </a>
                    <a class="app-hero__cta app-hero__cta--ghost" href="<?= base_url('aktivitas') ?>">
                        Aktivitas Harian
                        <span aria-hidden="true">→</span>
                    </a>
                </div>
                <div class="app-hero__stats fade-in-on-scroll">
                    <div class="stat-card">
                        <div class="stat-card__label">Proyek Selesai</div>
                        <div class="stat-card__value">24+</div>
                        <div class="stat-card__hint">Web · API · Dashboard</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-card__label">Kecepatan Respons</div>
                        <div class="stat-card__value">< 1 hari</div>
                        <div class="stat-card__hint">Estimasi rata-rata</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-card__label">Stack Utama</div>
                        <div class="stat-card__value">CI4 · MySQL</div>
                        <div class="stat-card__hint">+ Bootstrap/JS modern</div>
                    </div>
                </div>
                <div class="app-hero__scroll-hint fade-in-on-scroll">
                    <span class="app-hero__scroll-dot"></span>
                    <span>Gulir untuk melihat konten</span>
                </div>
            </div>
            <?php if ($bannerAsset): ?>
                <div class="app-hero__media">
                    <img src="<?= esc($bannerAsset) ?>" alt="Banner portofolio" loading="lazy">
                </div>
            <?php endif; ?>
        </div>
    </div>
</header>
