<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Portofolio Dimas Cahya Ramadhan</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?= base_url('css/bootstrap.min.css') ?>" />
    <link rel="stylesheet" href="<?= base_url('css/app.css') ?>" />
</head>

<body class="app-shell">

    <?= $this->include('layout/navbar') ?>
    <?php if (! isset($showHeader) || $showHeader !== false): ?>
        <?= $this->include('layout/header') ?>
    <?php endif; ?>

    <main class="app-main">
        <?= $this->renderSection('content') ?>
    </main>

    <?= $this->include('layout/footer') ?>

    <script src="<?= base_url('js/jquery-3.7.1.min.js') ?>"></script>
    <script>
        if (typeof window.jQuery === 'undefined') {
            const fallback = document.createElement('script');
            fallback.src = 'https://code.jquery.com/jquery-3.7.1.min.js';
            document.head.appendChild(fallback);
        }
    </script>
    <script src="<?= base_url('js/bootstrap.bundle.min.js') ?>"></script>
    <script>
        if (typeof window.bootstrap === 'undefined') {
            const fallback = document.createElement('script');
            fallback.src = 'https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js';
            document.body.appendChild(fallback);
        }
    </script>
    <script>
        // Loading state sederhana untuk filter/paginasi
        document.addEventListener('DOMContentLoaded', () => {
            const setLoading = () => document.body.classList.add('page-loading');

            document.querySelectorAll('.js-loading-form').forEach(form => {
                form.addEventListener('submit', () => setLoading());
            });

            document.querySelectorAll('[data-loading-links]').forEach(area => {
                area.querySelectorAll('a').forEach(link => {
                    if (link.target && link.target !== '_self') return;
                    link.addEventListener('click', () => setLoading());
                });
            });
        });
    </script>
    <script>
        // Fallback untuk navbar toggle jika Bootstrap tidak bekerja
        document.addEventListener('DOMContentLoaded', function() {
            const navbarToggler = document.querySelector('.navbar-toggler');
            const navbarCollapse = document.querySelector('#navbarNav');
            
            if (navbarToggler && navbarCollapse) {
                navbarToggler.addEventListener('click', function(e) {
                    e.preventDefault();
                    navbarCollapse.classList.toggle('show');
                    const isExpanded = navbarCollapse.classList.contains('show');
                    navbarToggler.setAttribute('aria-expanded', isExpanded);
                });
                
                // Tutup menu saat klik di luar
                document.addEventListener('click', function(e) {
                    if (!navbarToggler.contains(e.target) && !navbarCollapse.contains(e.target)) {
                        navbarCollapse.classList.remove('show');
                        navbarToggler.setAttribute('aria-expanded', 'false');
                    }
                });
            }

            // Scroll Animation dengan Intersection Observer
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };

            const observer = new IntersectionObserver(function(entries) {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('visible');
                        observer.unobserve(entry.target);
                    }
                });
            }, observerOptions);

            // Tambahkan class fade-in-on-scroll ke elemen yang ingin di-animate
            const animateElements = document.querySelectorAll('.home-featured-card, .home-latest-card, .news-card, .card-surface, .sidebar-card, .stat-card, .portfolio-hero__grid > *, .gallery-card');
            animateElements.forEach((el, index) => {
                el.classList.add('fade-in-on-scroll');
                if (el.classList.contains('portfolio-avatar')) {
                    el.dataset.variant = 'scale-up';
                } else if (el.classList.contains('portfolio-hero__cta-col')) {
                    el.dataset.variant = 'slide-left';
                }
                el.style.transitionDelay = (index * 0.1) + 's';
                observer.observe(el);
            });

            // Lightbox modal galeri + lazyload blur-removal
            const galleryModal = document.getElementById('galleryModal');
            let galleryList = Array.from(document.querySelectorAll('.gallery-card'));
            let currentIndex = 0;

            // Hilangkan blur saat gambar selesai load
            galleryList.forEach(card => {
                const img = card.querySelector('img');
                img?.addEventListener('load', () => {
                    img.classList.add('loaded');
                });
            });

            if (galleryModal) {
                galleryModal.addEventListener('show.bs.modal', event => {
                    const button = event.relatedTarget;
                    const src = button?.getAttribute('data-src');
                    currentIndex = galleryList.indexOf(button);
                    const targetImg = document.getElementById('galleryModalImage');
                    if (src && targetImg) {
                        targetImg.src = src;
                    }
                });

                const updateImage = (index) => {
                    if (!galleryList.length) return;
                    if (index < 0) index = galleryList.length - 1;
                    if (index >= galleryList.length) index = 0;
                    currentIndex = index;
                    const card = galleryList[currentIndex];
                    const src = card?.getAttribute('data-src');
                    const targetImg = document.getElementById('galleryModalImage');
                    if (src && targetImg) {
                        targetImg.src = src;
                    }
                };

                const prevBtn = document.querySelector('.gallery-nav--prev');
                const nextBtn = document.querySelector('.gallery-nav--next');
                prevBtn?.addEventListener('click', () => updateImage(currentIndex - 1));
                nextBtn?.addEventListener('click', () => updateImage(currentIndex + 1));

                document.addEventListener('keydown', (e) => {
                    if (!galleryModal.classList.contains('show')) return;
                    if (e.key === 'ArrowLeft') {
                        updateImage(currentIndex - 1);
                    } else if (e.key === 'ArrowRight') {
                        updateImage(currentIndex + 1);
                    }
                });
            }

            // Navbar scroll effect
            const navbar = document.querySelector('.app-navbar');
            if (navbar) {
                let lastScroll = 0;
                window.addEventListener('scroll', function() {
                    const currentScroll = window.pageYOffset;
                    if (currentScroll > 50) {
                        navbar.classList.add('scrolled');
                    } else {
                        navbar.classList.remove('scrolled');
                    }
                    lastScroll = currentScroll;
                });
            }
        });
    </script>

</body>

</html>
